/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.baltic;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import java.util.List;

public class RemoveNilParameterValues
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String errorMessage = null;
        if (data == null) {
            return null;
        }
        String parameters = (String)data.getPropertyValue("parameters");
        if (parameters == null || parameters.length() == 0) {
            return null;
        }
        String upgradedParameters = null;
        try {
            XMLElement parametersValueEl;
            XMLElement parametersEl;
            XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(parameters);
            if (rootEl != null && (parametersEl = rootEl.getChild(0)) != null && (parametersValueEl = parametersEl.getOptionalChildWithName("value")) != null && parametersValueEl.children_ != null) {
                if (!this.upgradeParameters(parametersValueEl.children_)) {
                    return null;
                }
                upgradedParameters = parametersEl.makeXML("", true, false, false);
            }
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            if (upgradedParameters != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("parameters", upgradedParameters);
                result.setData(upgradedData);
            }
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private boolean upgradeParameters(List<XMLElement> parameterValues) {
        if (parameterValues == null) {
            return false;
        }
        boolean upgraded = false;
        for (XMLElement parameterValueItemEl : parameterValues) {
            upgraded |= this.removeNilParameterValue(parameterValueItemEl);
        }
        return upgraded;
    }

    private boolean removeNilParameterValue(XMLElement parameterValueItemEl) {
        XMLElement itemEl;
        if (parameterValueItemEl == null) {
            return false;
        }
        XMLElement valueEl = parameterValueItemEl.getOptionalChildWithName("value");
        if (valueEl != null && (itemEl = valueEl.getOptionalChildWithNameEvenIfNil("item")) != null) {
            if (itemEl.isNil_) {
                parameterValueItemEl.deleteChildWithName("value");
                return true;
            }
            XMLElement subNodesEl = itemEl.getOptionalChildWithName("subNodes");
            if (subNodesEl != null && subNodesEl.children_ != null) {
                return this.upgradeParameters(subNodesEl.children_);
            }
        }
        return false;
    }
}

