/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.baltic;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public class UpdatePublicContentPolicy
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        XMLElement elPolicies = null;
        boolean foundMetricsAdmin = false;
        boolean foundPlanningAdmin = false;
        boolean foundPlanningUsers = false;
        boolean foundControllerAdmin = false;
        boolean foundControllerUsers = false;
        boolean foundMetricsAuthors = false;
        boolean foundMetricsUsers = false;
        boolean foundAnalysisUsers = false;
        try {
            String policiesXMLString = (String)data.getPropertyValue("policies");
            if (policiesXMLString == null || policiesXMLString.length() == 0) {
                return null;
            }
            XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
            if (policiesRootXML == null) {
                return null;
            }
            elPolicies = policiesRootXML.getChild(0);
            if (elPolicies == null) {
                return null;
            }
            XMLElement elPolicyArray = elPolicies.getChildWithName("value");
            if (elPolicyArray == null || elPolicyArray.children_ == null) {
                return null;
            }
            String[] adminActions = CMConstants.ALL_ACTIONS;
            String[] userActions = new String[]{"read", "traverse", "execute"};
            for (XMLElement policy : elPolicyArray.children_) {
                XMLElement elSecurityObj;
                String searchPath;
                if (policy == null || policy.children_ == null || (searchPath = (elSecurityObj = policy.getChildWithName("securityObject")).getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value")) == null) continue;
                if (searchPath.indexOf("Metrics Administrators") != -1) {
                    foundMetricsAdmin = true;
                    continue;
                }
                if (searchPath.indexOf("Planning Administrators") != -1) {
                    foundPlanningAdmin = true;
                    continue;
                }
                if (searchPath.indexOf("Planning Users") != -1) {
                    foundPlanningUsers = true;
                    continue;
                }
                if (searchPath.indexOf("Controller Administrators") != -1) {
                    foundControllerAdmin = true;
                    continue;
                }
                if (searchPath.indexOf("Controller Users") != -1) {
                    foundControllerUsers = true;
                    continue;
                }
                if (searchPath.indexOf("Metrics Authors") != -1) {
                    foundMetricsAuthors = true;
                    continue;
                }
                if (searchPath.indexOf("Metrics Users") != -1) {
                    foundMetricsUsers = true;
                    continue;
                }
                if (searchPath.indexOf("Analysis Users") == -1) continue;
                foundAnalysisUsers = true;
            }
            if (!foundMetricsAdmin) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Metrics Administrators\")", adminActions);
            }
            if (!foundPlanningAdmin) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Planning Administrators\")", adminActions);
            }
            if (!foundPlanningUsers) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Planning Users\")", userActions);
            }
            if (!foundControllerAdmin) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Controller Administrators\")", adminActions);
            }
            if (!foundControllerUsers) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Controller Users\")", userActions);
            }
            if (!foundMetricsAuthors) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Metrics Authors\")", userActions);
            }
            if (!foundMetricsUsers) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Metrics Users\")", userActions);
            }
            if (!foundAnalysisUsers) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Analysis Users\")", userActions);
            }
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        if (foundMetricsAdmin && foundPlanningAdmin && foundPlanningUsers && foundControllerAdmin && foundControllerUsers && foundMetricsAuthors && foundMetricsUsers && foundAnalysisUsers) {
            return null;
        }
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            if (newPoliciesXMLString != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("policies", newPoliciesXMLString);
                result.setData(upgradedData);
            }
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }
}

