/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.baltic;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public class UpdatePublicContentPolicy2
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        XMLElement elPolicies = null;
        boolean foundDataManagerAuthors = false;
        try {
            String policiesXMLString = (String)data.getPropertyValue("policies");
            if (policiesXMLString == null || policiesXMLString.length() == 0) {
                return null;
            }
            XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
            if (policiesRootXML == null) {
                return null;
            }
            elPolicies = policiesRootXML.getChild(0);
            if (elPolicies == null) {
                return null;
            }
            XMLElement elPolicyArray = elPolicies.getChildWithName("value");
            if (elPolicyArray == null || elPolicyArray.children_ == null) {
                return null;
            }
            String[] userActions = new String[]{"read", "traverse", "execute"};
            for (XMLElement policy : elPolicyArray.children_) {
                XMLElement elSecurityObj;
                String searchPath;
                if (policy == null || policy.children_ == null || (searchPath = (elSecurityObj = policy.getChildWithName("securityObject")).getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value")) == null || searchPath.indexOf("Data Manager Authors") == -1) continue;
                foundDataManagerAuthors = true;
            }
            if (!foundDataManagerAuthors) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Data Manager Authors\")", userActions);
            }
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        if (foundDataManagerAuthors) {
            return null;
        }
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            if (newPoliciesXMLString != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("policies", newPoliciesXMLString);
                result.setData(upgradedData);
            }
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }
}

