/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.dbstore.CMDbStoreUpgrade;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMXMLUtils;

public class AddSubscriptionFolder
implements CMUpgradePlugin {
    private static boolean bSrcSubscriptionFolderExists_ = false;
    private String scriptFileName = null;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        this.scriptFileName = desc.getCLibName();
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String errorMessage = null;
        if (data == null) {
            return null;
        }
        String camIdXML = (String)data.getPropertyValue("id");
        if (camIdXML == null) {
            return null;
        }
        if (!bSrcSubscriptionFolderExists_) {
            try {
                this.verifyAndCreateSubscriptionFolderToAccountTemplate(this.scriptFileName);
                bSrcSubscriptionFolderExists_ = true;
            }
            catch (CMException e) {
                errorMessage = e.getMessage();
            }
            if (!bSrcSubscriptionFolderExists_) {
                CMUpgradeResult result = new CMUpgradeResult();
                result.setMessage(errorMessage);
                result.setUpgradeStatus(2);
                result.setNextAction(2);
                return result;
            }
        }
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(camIdXML);
        String sCamId = null;
        if (rootEl != null) {
            XMLElement idXML = rootEl.getChild(0);
            XMLElement valueXML = null;
            if (idXML != null) {
                valueXML = idXML.getOptionalChildWithName("value");
            }
            if (valueXML != null) {
                sCamId = valueXML.value_;
            }
        }
        if (sCamId == null) {
            return null;
        }
        try {
            CMStore store = CMExecutionContext.get().getStore();
            store.verifyAndCreateMyDefaults(sCamId);
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            result.setData(null);
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAndCreateSubscriptionFolderToAccountTemplate(String scriptFileName) throws CMException {
        block6: {
            CMStoreQueryResults results = null;
            try {
                String sAccountSrcPath = "/configuration/account";
                String sSrcPath = sAccountSrcPath + "/" + "*[@objectClass='subscriptionFolder']";
                CMStoreXPath templateSrcPath = new CMStoreXPath(sSrcPath, 10);
                CMProperty[] properties = new CMProperty[]{CMProperty.SEARCHPATH};
                CMStore store = CMExecutionContext.get().getStore();
                results = store.executeQuery(templateSrcPath, properties, null, 0, 512, null);
                if (results != null && results.next()) break block6;
                try {
                    CMDbStoreUpgrade.RunCMUpgradeScript(scriptFileName);
                }
                catch (Exception e) {
                    CMException cmex = new CMException(e, "cmErrExeInit");
                    CMIndications.logException(cmex);
                    throw cmex;
                }
            }
            finally {
                if (results != null) {
                    results.release();
                }
            }
        }
    }
}

