/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public class UpdatePublicContentPolicy3
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        XMLElement elPolicies = null;
        boolean foundPowerPlayUsers = false;
        boolean foundPowerPlayAdmin = false;
        try {
            String policiesXMLString = (String)data.getPropertyValue("policies");
            if (policiesXMLString == null || policiesXMLString.length() == 0) {
                return null;
            }
            XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
            if (policiesRootXML == null) {
                return null;
            }
            elPolicies = policiesRootXML.getChild(0);
            if (elPolicies == null) {
                return null;
            }
            XMLElement elPolicyArray = elPolicies.getChildWithName("value");
            if (elPolicyArray == null || elPolicyArray.children_ == null) {
                return null;
            }
            String[] adminActions = CMConstants.ALL_ACTIONS;
            String[] userActions = new String[]{"read", "traverse", "execute"};
            for (XMLElement policy : elPolicyArray.children_) {
                XMLElement elSecurityObj;
                String searchPath;
                if (policy == null || policy.children_ == null || (searchPath = (elSecurityObj = policy.getChildWithName("securityObject")).getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value")) == null) continue;
                if (searchPath.indexOf("PowerPlay Administrators") != -1) {
                    foundPowerPlayAdmin = true;
                    continue;
                }
                if (searchPath.indexOf("PowerPlay Users") == -1) continue;
                foundPowerPlayUsers = true;
            }
            if (!foundPowerPlayAdmin) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":PowerPlay Administrators\")", adminActions);
            }
            if (!foundPowerPlayUsers) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":PowerPlay Users\")", userActions);
            }
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        if (foundPowerPlayUsers && foundPowerPlayAdmin) {
            return null;
        }
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            if (newPoliciesXMLString != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("policies", newPoliciesXMLString);
                result.setData(upgradedData);
            }
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }
}

