/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.bering;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public class UpdateSecuredFunctionPolicy
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        XMLElement elPolicies = null;
        boolean foundPowerPlayAdmin = false;
        boolean foundPowerPlayUsers = false;
        try {
            String userCapabilityXMLString = (String)data.getPropertyValue("userCapability");
            String policiesXMLString = (String)data.getPropertyValue("policies");
            if (userCapabilityXMLString == null || userCapabilityXMLString.length() == 0 || policiesXMLString == null || policiesXMLString.length() == 0) {
                return null;
            }
            XMLElement userCapabilityRootXML = CMXMLUtils.convertXMLString2XMLElement(userCapabilityXMLString);
            if (userCapabilityRootXML == null) {
                return null;
            }
            String userCapability = userCapabilityRootXML.getOptionalValueFromChildWithNameWithinChildWithName("userCapability", "value");
            if (userCapability == null) {
                return null;
            }
            if (userCapability.equalsIgnoreCase("canUseAdministrationPortal") || userCapability.equalsIgnoreCase("canUseCognosViewer") || userCapability.equalsIgnoreCase("canUseConditionalSubscriptions") || userCapability.equalsIgnoreCase("canUseScheduling")) {
                XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
                if (policiesRootXML == null) {
                    return null;
                }
                elPolicies = policiesRootXML.getChild(0);
                if (elPolicies == null) {
                    return null;
                }
                XMLElement elPolicyArray = elPolicies.getChildWithName("value");
                if (elPolicyArray == null || elPolicyArray.children_ == null) {
                    return null;
                }
                String[] actions = new String[]{"traverse", "execute"};
                for (XMLElement policy : elPolicyArray.children_) {
                    XMLElement elSecurityObj;
                    String searchPath;
                    if (policy == null || policy.children_ == null || (searchPath = (elSecurityObj = policy.getChildWithName("securityObject")).getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value")) == null) continue;
                    if (searchPath.indexOf("PowerPlay Administrators") != -1) {
                        foundPowerPlayAdmin = true;
                        continue;
                    }
                    if (searchPath.indexOf("PowerPlay Users") == -1) continue;
                    foundPowerPlayUsers = true;
                }
                if (!foundPowerPlayAdmin) {
                    CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":PowerPlay Administrators\")", actions);
                }
                if (!foundPowerPlayUsers && !userCapability.equalsIgnoreCase("canUseAdministrationPortal")) {
                    CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":PowerPlay Users\")", actions);
                }
            }
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        if (foundPowerPlayAdmin && foundPowerPlayUsers) {
            return null;
        }
        if (elPolicies == null) {
            return null;
        }
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            if (newPoliciesXMLString != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("policies", newPoliciesXMLString);
                result.setData(upgradedData);
            }
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }
}

