/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.blacksea;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.util.CMDataUpgradeUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class UpdateCapabilitiesPolicies
implements CMUpgradePlugin {
    public static final String canUseDirectoryTool = "canUseDirectoryTool";
    public static final String userCapability = "userCapability";

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        ArrayList<CMUpgradeMessage> errorMessages = new ArrayList<CMUpgradeMessage>();
        boolean errorOccured = false;
        boolean cmShutDown = false;
        String userCapabilityVal = CMDataUpgradeUtils.getPropertyValue(data, userCapability);
        if (userCapabilityVal == null || !userCapabilityVal.equalsIgnoreCase(canUseDirectoryTool)) {
            return null;
        }
        String searchPath = CMDataUpgradeUtils.getPropertyValue(data, "searchPath");
        String policiesXML = (String)data.getPropertyValue("policies");
        if (searchPath == null) {
            errorMessages.add(new CMUpgradeMessage("Unable to determine the searchPath for the securedFeature", 40000));
            errorOccured = true;
        }
        if (!errorOccured) {
            try {
                if (policiesXML != null) {
                    this.updatePolicies(searchPath + "/../securedFeature", policiesXML);
                }
                this.delete(searchPath);
            }
            catch (UpdateCapabilitiesPoliciesException e) {
                errorMessages.add(new CMUpgradeMessage(e.getMessage(), 40000));
                errorOccured = true;
                if (e.type == 0) {
                    cmShutDown = true;
                }
            }
            catch (Exception e) {
                errorMessages.add(new CMUpgradeMessage(e.getMessage(), 40000));
                errorOccured = true;
            }
        }
        if (errorOccured) {
            CMUpgradeResult result = new CMUpgradeResult();
            result.setMessages(errorMessages);
            if (cmShutDown) {
                result.setNextAction(2);
            } else {
                result.setNextAction(1);
            }
            result.setUpgradeStatus(2);
            return result;
        }
        return null;
    }

    private void updatePolicies(String searchPath, String policiesXML) throws Exception {
        String query2 = CMDataUpgradeUtils.buildQuery(searchPath, new String[]{"searchPath", userCapability, "policies"});
        String response = ContentManager.getInstance().ExecuteStaticRequest(query2, false, true);
        if (response == null) {
            throw new UpdateCapabilitiesPoliciesException("CM has been shutdown. Abort data upgrade!", 0);
        }
        if (response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Query failed:\n" + response);
        }
        ArrayList<String> searchPathes = new ArrayList<String>();
        for (Element curSecuredFeature : this.extractSecuredFeaturesElements(response)) {
            Element searchPathValueEle;
            Element searchPathEle;
            Element userCapabilityValueEle;
            Element userCapabilityEle = curSecuredFeature.element(userCapability);
            if (userCapabilityEle == null || (userCapabilityValueEle = userCapabilityEle.element("value")) == null || !userCapabilityValueEle.getText().equalsIgnoreCase("canUseDataSourcesTool") && !userCapabilityValueEle.getText().equalsIgnoreCase("canUseDistributionListsAndContactsTool") && !userCapabilityValueEle.getText().equalsIgnoreCase("canUsePrintersTool") && !userCapabilityValueEle.getText().equalsIgnoreCase("canUseUsersGroupsAndRolesTool") || (searchPathEle = curSecuredFeature.element("searchPath")) == null || (searchPathValueEle = searchPathEle.element("value")) == null) continue;
            searchPathes.add(searchPathValueEle.getText());
        }
        String updateRequest = this.buildUpdateSecuredFeaturePolicies(searchPathes, policiesXML);
        response = ContentManager.getInstance().ExecuteStaticRequest(updateRequest, false, true);
        if (response == null) {
            throw new UpdateCapabilitiesPoliciesException("CM has been shutdown. Abort data upgrade!", 0);
        }
        if (response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Query failed:\n" + response);
        }
    }

    private void delete(String searchPath) throws Exception {
        String deleteRequest = CMDataUpgradeUtils.buildDelete(searchPath, false);
        String response = ContentManager.getInstance().ExecuteStaticRequest(deleteRequest, false, true);
        if (response == null) {
            throw new UpdateCapabilitiesPoliciesException("CM has been shutdown. Abort data upgrade!", 0);
        }
        if (response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Delete failed:\n" + response);
        }
    }

    private List extractSecuredFeaturesElements(String response) throws Exception {
        Document responseDoc;
        List result = null;
        SAXReader reader = new SAXReader();
        try {
            responseDoc = reader.read((Reader)new StringReader(response));
        }
        catch (DocumentException e1) {
            throw new Exception("Query response is not valid XML");
        }
        try {
            Element soapBodyEle = responseDoc.getRootElement().element("Body");
            Element queryResponseEle = soapBodyEle.element("queryResponse");
            Element queryResultEle = queryResponseEle.element("queryResult");
            result = queryResultEle.elements("item");
        }
        catch (NullPointerException e) {
            throw new Exception("Query response does not contain item elements");
        }
        return result;
    }

    private String buildUpdateSecuredFeaturePolicies(List<String> searchPathes, String policiesXML) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:update xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n\t<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:baseClass[").append(searchPathes.size()).append("]\">\n");
        for (int i = 0; i < searchPathes.size(); ++i) {
            gather.append("\t\t<item xsi:type=\"cm:securedFeature\">\n\t\t\t<searchPath xsi:type=\"cm:stringProp\">\n\t\t\t\t<value xsi:type=\"xsi:string\">").append(searchPathes.get(i)).append("</value>\n\t\t\t</searchPath>\n\t\t\t").append(policiesXML).append("\n");
            gather.append("\t\t</item>\n");
        }
        gather.append("\t</objects>\n</cm:update>");
        return gather.toString();
    }

    private class UpdateCapabilitiesPoliciesException
    extends Exception {
        private static final long serialVersionUID = 3380458019139491620L;
        public static final int TYPE_CM_SHUTDOWN = 0;
        private int type;

        public UpdateCapabilitiesPoliciesException(String message, int type) {
            super(message);
            this.type = type;
        }
    }
}

