/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.blacksea;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class UpdateDrillPathPrompt
implements CMUpgradePlugin {
    private static final String PROMPT = "prompt";
    private static final String TYPE_OPTION_ARRAY_PROP = "optionArrayProp";
    private static final String TYPE_RUN_OPTION_BOOLEAN = "runOptionBoolean";
    private static final String TYPE_RUN_OPTION_ENUM = "runOptionEnum";
    private static XMLElement defaultOptionsEl_ = null;

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        this.setDefaults();
        String options = null;
        if (data != null) {
            options = (String)data.getPropertyValue("options");
        }
        String upgradedOptions = null;
        CMUpgradeMessage errMessage = null;
        if (options == null) {
            upgradedOptions = defaultOptionsEl_.makeXML("", true, false, false);
        } else {
            try {
                upgradedOptions = this.upgradeOptions(options);
                if (upgradedOptions == null) {
                    return null;
                }
            }
            catch (Exception ex) {
                errMessage = new CMUpgradeMessage(ex.getMessage(), 40000);
            }
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errMessage != null) {
            ArrayList<CMUpgradeMessage> errMessages = new ArrayList<CMUpgradeMessage>();
            errMessages.add(errMessage);
            result.setMessages(errMessages);
            result.setUpgradeStatus(2);
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            if (upgradedOptions != null) {
                upgradedData.put("options", upgradedOptions);
            }
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private void setDefaults() {
        if (defaultOptionsEl_ != null) {
            return;
        }
        defaultOptionsEl_ = new XMLElement("options", CMSOAPConstants.NS_BIBUS, TYPE_OPTION_ARRAY_PROP);
        XMLElement optionsValueEl = defaultOptionsEl_.addChild(null, "value", CMSOAPConstants.NS_BIBUS, CMPropertyTypes.BIBUS_RUNOPTIONARRAY.getName());
        XMLElement optionEl = optionsValueEl.addChild(null, "item", CMSOAPConstants.NS_BIBUS, TYPE_RUN_OPTION_BOOLEAN);
        optionEl.addChild(null, "name", CMSOAPConstants.NS_BIBUS, TYPE_RUN_OPTION_ENUM, PROMPT);
        optionEl.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "boolean", "false");
    }

    private String upgradeOptions(String options) throws Exception {
        String upgradedOptionsXML = null;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(options);
        if (rootEl == null) {
            return defaultOptionsEl_.makeXML("", true, false, false);
        }
        XMLElement optionsEl = rootEl.getChild(0);
        if (optionsEl == null) {
            return defaultOptionsEl_.makeXML("", true, false, false);
        }
        XMLElement optionsValueEl = optionsEl.getOptionalChildWithName("value");
        if (optionsValueEl == null) {
            return defaultOptionsEl_.makeXML("", true, false, false);
        }
        ArrayList<XMLElement> listOptions = optionsValueEl.getChildren();
        for (int i = 0; i < listOptions.size(); ++i) {
            XMLElement itemEl = (XMLElement)listOptions.get(i);
            String name = itemEl.getOptionalChildValueWithName("name");
            if (name == null || !name.equals(PROMPT)) continue;
            return null;
        }
        XMLElement optionItemEl = optionsValueEl.addChild(null, "item", CMSOAPConstants.NS_BIBUS, TYPE_RUN_OPTION_BOOLEAN);
        optionItemEl.addChild(null, "name", CMSOAPConstants.NS_BIBUS, TYPE_RUN_OPTION_ENUM, PROMPT);
        optionItemEl.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "boolean", "false");
        upgradedOptionsXML = optionsEl.makeXML("", true, false, false);
        return upgradedOptionsXML;
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

