/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.blacksea;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Text;

public class UpdatePowerPlayXsdToCmNSPrefix
implements CMUpgradePlugin {
    private static final String badDataEnum = "xsd:powerPlay8DataEnum";
    private static final String badFormatEnum = "xsd:powerPlay8OutputFormatEnum";
    private static final String goodDataEnum = "cm:powerPlay8DataEnum";
    private static final String goodFormatEnum = "cm:powerPlay8OutputFormatEnum";
    private static final String badNodesXPath = "//item/value[@xsi:type='xsd:powerPlay8DataEnum'] | //item/value[@xsi:type='xsd:powerPlay8OutputFormatEnum']";
    private static final String txtChildXPath = "child::text()";

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String sOptions = (String)data.getPropertyValue("options");
        if (sOptions == null || sOptions.length() == 0) {
            return null;
        }
        if (sOptions.indexOf(badDataEnum) != -1 || sOptions.indexOf(badFormatEnum) != -1) {
            try {
                StringBuffer xmlDocStrBuf = new StringBuffer();
                xmlDocStrBuf.append("<root ").append(XMLElement.getCMPrefixes()).append(">").append(sOptions).append("</root>");
                Document doc = DocumentHelper.parseText((String)xmlDocStrBuf.toString());
                List list = doc.selectNodes(badNodesXPath);
                for (Element elem : list) {
                    Attribute attr = elem.attribute("type");
                    String attrValue = attr.getText();
                    if (badDataEnum.equals(attrValue)) {
                        elem.remove(attr);
                        elem.addAttribute("xsi:type", goodDataEnum);
                    }
                    if (!badFormatEnum.equals(attrValue)) continue;
                    elem.remove(attr);
                    elem.addAttribute("xsi:type", goodFormatEnum);
                    List tList = elem.selectNodes(txtChildXPath);
                    for (Text tElem : tList) {
                        if (tElem == null || !tElem.getText().equals("HTML") || !elem.remove(tElem)) continue;
                        elem.addText("PDF");
                    }
                }
                String xmlFragment = doc.getRootElement().element("options").asXML();
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("options", xmlFragment);
                CMUpgradeResult upgradeResult = new CMUpgradeResult();
                upgradeResult.setData(map);
                upgradeResult.setNextAction(1);
                upgradeResult.setUpgradeStatus(1);
                return upgradeResult;
            }
            catch (Exception e) {
                throw new CMException(e, "cmBadPropValue", new CMException.Parm("options", sOptions));
            }
        }
        return null;
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

