/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.blacksea;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class UpdatePromptCacheMode
implements CMUpgradePlugin {
    private static final String NAME_REFRESHPROMPTCACHE = "refreshPromptCache";
    private static final String NAME_PROMPTCACHEMODE = "promptCacheMode";
    private static final String TYPE_RUN_OPTION = "runOptionPromptCacheMode";
    private static final String TYPE_RUN_OPTION_ENUM = "runOptionEnum";
    private static final String PROMPTCACHEMODE_REFRESH = "refresh";
    private static final String TYPE_PROMPTCACHEMODE_ENUM = "promptCacheModeEnum";

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String options = null;
        if (data == null) {
            return null;
        }
        options = (String)data.getPropertyValue("options");
        if (options == null) {
            return null;
        }
        String upgradedOptions = null;
        CMUpgradeMessage errMessage = null;
        try {
            upgradedOptions = this.upgradeOptions(options);
            if (upgradedOptions == null) {
                return null;
            }
        }
        catch (CMException ex) {
            errMessage = new CMUpgradeMessage(ex.getMessage(), 40000);
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errMessage != null) {
            ArrayList<CMUpgradeMessage> errMessages = new ArrayList<CMUpgradeMessage>();
            errMessages.add(errMessage);
            result.setMessages(errMessages);
            result.setUpgradeStatus(2);
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            if (upgradedOptions != null) {
                upgradedData.put("options", upgradedOptions);
            }
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private String upgradeOptions(String options) throws CMException {
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(options);
        if (rootEl == null) {
            return null;
        }
        XMLElement optionsEl = rootEl.getChild(0);
        if (optionsEl == null) {
            return null;
        }
        XMLElement optionsValueEl = optionsEl.getOptionalChildWithName("value");
        if (optionsValueEl == null) {
            return null;
        }
        boolean foundRefreshPromptCache = false;
        boolean replaceValue = false;
        ArrayList<XMLElement> listOptions = optionsValueEl.getChildren();
        for (int i = 0; i < listOptions.size(); ++i) {
            XMLElement itemEl = (XMLElement)listOptions.get(i);
            String name = itemEl.getOptionalChildValueWithName("name");
            if (name == null || !name.equals(NAME_REFRESHPROMPTCACHE)) continue;
            replaceValue = itemEl.getOptionalChildBooleanValueWithName("value", false);
            listOptions.remove(i);
            foundRefreshPromptCache = true;
            break;
        }
        if (!foundRefreshPromptCache) {
            return null;
        }
        if (replaceValue) {
            XMLElement optionItemEl = optionsValueEl.addChild(null, "item", CMSOAPConstants.NS_BIBUS, TYPE_RUN_OPTION);
            optionItemEl.addChild(null, "name", CMSOAPConstants.NS_BIBUS, TYPE_RUN_OPTION_ENUM, NAME_PROMPTCACHEMODE);
            optionItemEl.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, TYPE_PROMPTCACHEMODE_ENUM, PROMPTCACHEMODE_REFRESH);
        }
        return optionsEl.makeXML("", true, false, false);
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

