/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.blacksea;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class UpdatePublicFolderPolicy
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        boolean errorOccured = false;
        ArrayList<CMUpgradeMessage> errorMessages = new ArrayList<CMUpgradeMessage>();
        XMLElement elPolicies = null;
        boolean foundExpressAuthors = false;
        boolean foundReaders = false;
        try {
            String policiesXMLString = (String)data.getPropertyValue("policies");
            if (policiesXMLString == null || policiesXMLString.length() == 0) {
                return null;
            }
            XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
            if (policiesRootXML == null) {
                return null;
            }
            elPolicies = policiesRootXML.getChild(0);
            if (elPolicies == null) {
                return null;
            }
            XMLElement elPolicyArray = elPolicies.getChildWithName("value");
            if (elPolicyArray == null || elPolicyArray.children_ == null) {
                return null;
            }
            String[] ExpressAuthorActions = new String[]{"read", "write", "traverse", "execute"};
            String[] readerActions = new String[]{"traverse", "read"};
            for (XMLElement policy : elPolicyArray.children_) {
                XMLElement elSecurityObj;
                String searchPath;
                if (policy == null || policy.children_ == null || (searchPath = (elSecurityObj = policy.getChildWithName("securityObject")).getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value")) == null) continue;
                if (!foundExpressAuthors && searchPath.indexOf("Express Authors") != -1) {
                    foundExpressAuthors = true;
                }
                if (foundReaders || searchPath.indexOf("Readers") == -1) continue;
                foundReaders = true;
            }
            if (!foundExpressAuthors) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Express Authors\")", ExpressAuthorActions);
            }
            if (!foundReaders) {
                CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Readers\")", readerActions);
            }
        }
        catch (CMException e) {
            errorMessages.add(new CMUpgradeMessage(e.getMessage(), 40000));
            errorOccured = true;
        }
        if (foundExpressAuthors && foundReaders) {
            return null;
        }
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorOccured) {
            result.setMessages(errorMessages);
            result.setUpgradeStatus(2);
        } else {
            if (newPoliciesXMLString != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("policies", newPoliciesXMLString);
                result.setData(upgradedData);
            }
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }
}

