/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.blacksea;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UpdateSecureFeatureOrFunctionPolicies
implements CMUpgradePlugin {
    private boolean updateReaders;
    private boolean foundExpressAuthors;
    private boolean foundReaders;
    private boolean areAcquired;
    private boolean fromDeployment;
    private String[] userPermissionsTX;
    private List<CMUpgradeMessage> errorMessages;
    private String objectSearchPath;
    private String parentSearchPath;
    private CMUpgradeResult result;
    private int action;
    private static final int ACTION_NOACTION = 0;
    private static final int ACTION_UNCONDITIONALUPDATE = 1;
    private static final int ACTION_CONDITIONALUPDATE = 2;
    private static final int ACTION_COPYFROMPARENT = 3;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        this.userPermissionsTX = new String[]{"traverse", "execute"};
        this.errorMessages = new ArrayList<CMUpgradeMessage>();
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        this.fromDeployment = false;
        this.action = 0;
        this.updateReaders = false;
        this.foundExpressAuthors = false;
        this.foundReaders = false;
        this.areAcquired = false;
        this.objectSearchPath = null;
        this.parentSearchPath = null;
        if (!this.errorMessages.isEmpty()) {
            this.errorMessages.clear();
        }
        try {
            if (!this.actionRequired(data)) {
                return null;
            }
            this.result = new CMUpgradeResult();
            this.objectSearchPath = CMDataUpgradeUtils.getSearchPath(data);
            this.fromDeployment = CMDataUpgradeUtils.getIsFromDeployment(data);
            if (this.fromDeployment) {
                return this.deploymentUpdate(data, this.result);
            }
            this.areAcquired = CMDataUpgradeUtils.getAreAcquired(data);
            if (this.action == 1 || !this.areAcquired && this.action == 2 || this.areAcquired && this.action == 3) {
                return this.contentStoreUpgrade(data, this.result);
            }
        }
        catch (CMException e) {
            this.errorMessages.add(new CMUpgradeMessage(e.getMessage(), 40000));
            this.result.setMessages(this.errorMessages);
            this.result.setUpgradeStatus(2);
            this.result.setNextAction(1);
            return this.result;
        }
        return null;
    }

    private boolean actionRequired(CMUpgradeData data) throws Exception {
        String userCapabilityXMLString = (String)data.getPropertyValue("userCapability");
        if (userCapabilityXMLString == null || userCapabilityXMLString.length() == 0) {
            return false;
        }
        XMLElement userCapabilityRootXML = CMXMLUtils.convertXMLString2XMLElement(userCapabilityXMLString);
        if (userCapabilityRootXML == null) {
            return false;
        }
        String userCapability = userCapabilityRootXML.getOptionalValueFromChildWithNameWithinChildWithName("userCapability", "value");
        if (userCapability == null) {
            return false;
        }
        if (userCapability.equalsIgnoreCase("canUseCognosViewer") || userCapability.equalsIgnoreCase("canUseCognosViewerContextMenu") || userCapability.equalsIgnoreCase("canUseCognosViewerSelection") || userCapability.equalsIgnoreCase("canUseCognosViewerToolbar")) {
            this.updateReaders = true;
        }
        if (userCapability.equalsIgnoreCase("canUseCognosViewer") || userCapability.equalsIgnoreCase("canUseConditionalSubscriptions") || userCapability.equalsIgnoreCase("canUseReportStudio") || userCapability.equalsIgnoreCase("canUseScheduling")) {
            this.action = 1;
            return true;
        }
        if (userCapability.equalsIgnoreCase("canUseCognosViewerRunWithOptions") || userCapability.equalsIgnoreCase("canUseBursting") || userCapability.equalsIgnoreCase("canUseUserDefinedSQL") || userCapability.equalsIgnoreCase("canUseHTML")) {
            this.action = 3;
            return true;
        }
        if (userCapability.equalsIgnoreCase("canUseCognosViewerContextMenu") || userCapability.equalsIgnoreCase("canUseCognosViewerSelection") || userCapability.equalsIgnoreCase("canUseCognosViewerToolbar") || userCapability.equalsIgnoreCase("canUseReportStudioFileManagement")) {
            this.action = 2;
            return true;
        }
        return false;
    }

    private CMUpgradeResult deploymentUpdate(CMUpgradeData data, CMUpgradeResult result) throws Exception {
        String policiesXMLString = (String)data.getPropertyValue("policies");
        if (policiesXMLString == null) {
            CMStoreXPath objectSearchXPath = new CMStoreXPath(this.objectSearchPath);
            CMStoreXPath parentSearchXPath = (CMStoreXPath)objectSearchXPath.getParent();
            this.parentSearchPath = parentSearchXPath.toString();
            if (this.action == 3 || this.action == 1) {
                return this.copyFromParentUpgrade(data, result);
            }
            return null;
        }
        if (this.action != 3) {
            return this.contentStoreUpgrade(data, result);
        }
        return null;
    }

    private CMUpgradeResult contentStoreUpgrade(CMUpgradeData data, CMUpgradeResult result) throws Exception {
        this.foundReaders = false;
        this.foundExpressAuthors = false;
        String policiesXMLString = (String)data.getPropertyValue("policies");
        XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
        if (policiesRootXML == null) {
            return null;
        }
        XMLElement elPolicies = policiesRootXML.getChild(0);
        if (elPolicies == null) {
            return null;
        }
        XMLElement elPolicyArray = elPolicies.getChildWithName("value");
        if (elPolicyArray == null || elPolicyArray.children_ == null) {
            return null;
        }
        for (int i = 0; i < elPolicyArray.children_.size(); ++i) {
            XMLElement elSecurityObj;
            String searchPath;
            XMLElement policy = elPolicyArray.children_.get(i);
            if (policy == null || policy.children_ == null || (searchPath = (elSecurityObj = policy.getChildWithName("securityObject")).getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value")) == null) continue;
            if (searchPath.indexOf("Express Authors") != -1) {
                this.foundExpressAuthors = true;
                continue;
            }
            if (searchPath.indexOf("Readers") == -1) continue;
            this.foundReaders = true;
            if (this.updateReaders) continue;
            elPolicyArray.children_.remove(i--);
            this.foundReaders = false;
        }
        if (!this.foundExpressAuthors) {
            CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Express Authors\")", this.userPermissionsTX);
        }
        if (!this.foundReaders && this.updateReaders) {
            CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, "CAMID(\":Readers\")", this.userPermissionsTX);
        }
        if (this.foundReaders && this.foundExpressAuthors) {
            return null;
        }
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        if (newPoliciesXMLString != null) {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put("policies", newPoliciesXMLString);
            result.setData(upgradedData);
        }
        result.setUpgradeStatus(1);
        result.setNextAction(1);
        return result;
    }

    private CMUpgradeResult copyFromParentUpgrade(CMUpgradeData data, CMUpgradeResult result) throws Exception {
        int count;
        String query2 = CMDataUpgradeUtils.buildQuery(this.parentSearchPath, new String[]{"searchPath", "policies"});
        String response = ContentManager.getInstance().ExecuteStaticRequest(query2, false, true);
        if (response == null || response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new CMException("Query failed:\n" + response);
        }
        List<String> policiesList = CMDataUpgradeUtils.extractPoliciesFromResponseXML(response);
        StringBuffer policyBuffer = new StringBuffer();
        boolean foundReaders = false;
        boolean foundExpressAuthors = false;
        for (count = 0; count < policiesList.size(); ++count) {
            String temp = policiesList.get(count);
            if (temp.indexOf("Readers") != -1) {
                if (!this.updateReaders) continue;
                foundReaders = true;
                policyBuffer.append(temp);
                continue;
            }
            if (temp.indexOf("Express Authors") != -1) {
                foundExpressAuthors = true;
            }
            policyBuffer.append(temp);
        }
        if (!foundExpressAuthors) {
            policyBuffer.append("                <item xsi:type=\"bus:policy\">\n                     <securityObject xsi:type=\"bus:nil\">\n                        <searchPath xsi:type=\"bus:stringProp\">\n                          <!-- Express Authors T X -->\n                            \t<value xsi:type=\"xsd:string\" xml:space=\"preserve\">CAMID(&quot;:Express Authors&quot;)</value>\n                        </searchPath>\n                    </securityObject>\n                    <permissions xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:permission[2]\">\n                    <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">traverse</name>\n                       \t<access xsi:type=\"bus:accessEnum\">grant</access>\n                   </item>\n                   <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">execute</name>\n                       \t<access xsi:type=\"cm:accessEnum\">grant</access>\n                   </item>\n                   </permissions>\n             </item>\n");
            ++count;
        }
        if (this.updateReaders && !foundReaders) {
            policyBuffer.append("                   <item xsi:type=\"bus:policy\">\n                     \"<securityObject xsi:type=\"bus:nil\">\n                     \"   <searchPath xsi:type=\"cm:stringProp\">\n                          <!-- Readers T X -->\n                            \t<value xsi:type=\"xsd:string\" xml:space=\"preserve\">CAMID(&quot;:Readers&quot;)</value>\n                       \t</searchPath>\n                   </securityObject>\n                   <permissions xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:permission[2]\">\n                   <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">traverse</name>\n                       \t<access xsi:type=\"bus:accessEnum\">grant</access>\n                   </item>\n                   <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">execute</name>\n                       \t<access xsi:type=\"bus:accessEnum\">grant</access>\n                   </item>\n                   </permissions>\n             </item>\n");
            ++count;
        }
        policyBuffer.append("                   </value>\n               </policies>\n");
        String newPolicies = CMDataUpgradeUtils.getPoliciesHead(count) + policyBuffer.toString();
        HashMap<String, String> upgradedData = new HashMap<String, String>();
        upgradedData.put("policies", newPolicies);
        result.setData(upgradedData);
        result.setUpgradeStatus(1);
        result.setNextAction(1);
        return result;
    }
}

