/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.bluesea;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public class UpdateAdminSecuredFunctionPolicy
implements CMUpgradePlugin {
    private static final String ADAPTIVE_ANALYTICS_ADMINISTRATORS = "Adaptive Analytics Administrators";
    private static final String SEARCHPATH_ADAPTIVE_ANALYTICS_ADMINISTRATORS_ROLE = "CAMID(\":Adaptive Analytics Administrators\")";

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        if (UpgradeUtils.isMidmarket(data)) {
            return null;
        }
        String errorMessage = null;
        String newPoliciesXMLString = null;
        try {
            String userCapabilityXMLString = (String)data.getPropertyValue("userCapability");
            if (userCapabilityXMLString == null || userCapabilityXMLString.indexOf("canUseAdministrationPortal") == -1) {
                return null;
            }
            String policiesXMLString = (String)data.getPropertyValue("policies");
            if (policiesXMLString == null || policiesXMLString.indexOf(ADAPTIVE_ANALYTICS_ADMINISTRATORS) != -1) {
                return null;
            }
            newPoliciesXMLString = this.addItemsToPolicies(policiesXMLString);
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else if (newPoliciesXMLString == null) {
            result.setUpgradeStatus(0);
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put("policies", newPoliciesXMLString);
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private String addItemsToPolicies(String policiesXMLString) throws CMException {
        XMLElement elPolicies = null;
        XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
        if (policiesRootXML == null) {
            return null;
        }
        elPolicies = policiesRootXML.getChild(0);
        if (elPolicies == null) {
            return null;
        }
        XMLElement elPolicyArray = elPolicies.getChildWithName("value");
        if (elPolicyArray == null || elPolicyArray.children_ == null) {
            return null;
        }
        String[] actions = new String[]{"traverse", "execute"};
        CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, SEARCHPATH_ADAPTIVE_ANALYTICS_ADMINISTRATORS_ROLE, actions);
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        return newPoliciesXMLString;
    }
}

