/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.caspian;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multitenancy.TenantRegistry;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathFactory;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.cognos.pogo.util.NameValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AddMissingTenantObjects
implements CMUpgradePlugin {
    public static final String PLUGIN_FAMILY = "CM_internal";
    public static final String PLUGIN_ID = "CM_internal_5.018";
    public static final float VERSION = 5.018f;
    private CMStorePathFactory pathFactory;
    private CMStore store;
    private TenantRegistry registry;
    private List<CMUpgradeMessage> messages;

    public AddMissingTenantObjects() {
        this(new CMStorePathFactory());
    }

    public AddMissingTenantObjects(CMStorePathFactory factory) {
        this.pathFactory = factory;
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    protected void initializeForCurrentRun() throws CMException {
        this.store = CMExecutionContext.get().getStore();
        this.registry = this.store.getTenantRegistry();
        this.messages = new ArrayList<CMUpgradeMessage>();
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        return this.addMissingTenants(Collections.singleton(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMUpgradeResult addMissingTenants(Set<String> originalTenants) throws CMException {
        CMUpgradeResult result;
        this.initializeForCurrentRun();
        Set<String> newTenants = this.registry.getTenantIdStrings();
        if (originalTenants.containsAll(newTenants)) {
            return CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        }
        CMExecutionContext context = CMExecutionContext.get();
        CMStoreXPath tenantsPath = this.lockTenants();
        try {
            Collection<String> idsOfMissingTenants = this.determineIdsOfMissingTenants(originalTenants);
            if (context.getCurrentUserIsAdministrator() || context.getContext().getCurrentUserSession() == null) {
                this.createTenants(tenantsPath, idsOfMissingTenants);
                Map<String, String> empty = Collections.emptyMap();
                result = CMUpgradeResultFactory.createSuccessUpgradeResult(empty);
            } else {
                this.notifyOfNewTenantIds(idsOfMissingTenants);
                result = new CMUpgradeResult();
                result.setUpgradeStatus(2);
            }
        }
        catch (CMException e) {
            result = CMUpgradeResultFactory.createErrorUpgradeResult(e.getMessage());
        }
        finally {
            this.store.getLockManager().releaseLocks();
        }
        result.setMessages(this.messages);
        return result;
    }

    private CMStoreXPath lockTenants() throws CMStoreParseException, CMException {
        CMStoreXPath tenantsPath = this.pathFactory.createCMStoreXPath("/directory/tenants", 11);
        this.store.getLockManager().requestLocks(tenantsPath);
        return tenantsPath;
    }

    protected Collection<String> determineIdsOfMissingTenants(Set<String> tenantsBeforeImport) throws CMException {
        Set<String> tenantIds = this.registry.getTenantIdStrings();
        tenantIds.removeAll(tenantsBeforeImport);
        List<String> modelledTenants = this.queryExistingTenants();
        tenantIds.removeAll(modelledTenants);
        return tenantIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> queryExistingTenants() throws CMException {
        ArrayList<String> modelledTenants = new ArrayList<String>();
        CMStoreXPath templateSrcPath = this.pathFactory.createCMStoreXPath("/directory/tenants/tenant", 10);
        CMProperty[] tenantId = new CMProperty[]{CMProperty.TENANTID};
        CMStoreQueryResults results = this.store.executeQuery(templateSrcPath, tenantId, null, 0, 512, null);
        try {
            while (results.next()) {
                modelledTenants.add(results.getValue(0).toString());
            }
        }
        finally {
            results.release();
        }
        return modelledTenants;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTenants(CMStoreXPath tenantsPath, Collection<String> tenantIds) throws CMException {
        List<CMProperty> properties = Collections.singletonList(CMProperty.TENANTID);
        for (String tenantId : tenantIds) {
            this.store.beginTransaction();
            try {
                String name = this.getUniqueNameForTenant(tenantId);
                CMStoreQueryResults results = null;
                try {
                    results = this.store.addObject(tenantsPath, (CMBasePropertyValue)new CMDbStoreString(name), CMObjectClass.TENANT, properties, Collections.singletonList(tenantId));
                    if (results.next()) {
                        this.addTenantCreatedMessage(results.getSearchPath(), tenantId);
                    }
                }
                finally {
                    if (results != null) {
                        results.release();
                    }
                }
                this.store.commitTransaction();
            }
            finally {
                this.store.rollbackOpenTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUniqueNameForTenant(String tenantId) throws CMException {
        String baseName;
        String name = baseName = CMStringUtils.normalizeApostropheAndQuote(tenantId);
        boolean unique = false;
        int count = 1;
        CMStoreQueryResults results = null;
        while (!unique) {
            String searchPath = "/directory/tenants/tenant[@name=\"" + SearchPathEncoder.escapeDelimiter((String)name, (char)'\"') + "\"]";
            try {
                results = this.store.executeQuery(searchPath, new CMProperty[]{CMProperty.STOREID}, null, 1, 512, null);
                unique = !results.next();
            }
            finally {
                if (results != null) {
                    results.release();
                }
            }
            if (unique) continue;
            name = baseName + count;
            ++count;
        }
        return name;
    }

    private void notifyOfNewTenantIds(Collection<String> idsOfMissingTenants) {
        CMUpgradeMessage errorMessage = new CMUpgradeMessage(CMError.getMessage("cmArchiveContainedRestrictedTenants", new NameValuePair[0]), 40000);
        this.messages.add(errorMessage);
        for (String missing : idsOfMissingTenants) {
            CMIndications.logException(new CMException("cmTenantObjectNotCreated", new CMException.Parm("tenantID", missing)));
        }
    }

    protected void addTenantCreatedMessage(String searchPath, String tenantID) {
        String messageText = CMError.getMessage("cmTenantCreated", new CMException.Parm[]{new CMException.Parm("searchPath", searchPath), new CMException.Parm("tenantID", tenantID)});
        CMUpgradeMessage message = new CMUpgradeMessage(messageText, 20000);
        this.messages.add(message);
    }

    public List<CMUpgradeMessage> getMessages() {
        return this.messages;
    }

    public void terminate() throws Exception {
    }

    public boolean shouldRun(boolean isBalticArchive, Map<String, String> archivePlugins, boolean isEntireContentStoreSelect) {
        if (isBalticArchive || !isEntireContentStoreSelect) {
            return true;
        }
        String versionFromArchive = archivePlugins.get(PLUGIN_FAMILY);
        return versionFromArchive == null || Float.parseFloat(versionFromArchive) < 5.018f;
    }
}

