/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.caspian;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.ContentTaskOption;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FixContentTaskOptionType
implements CMUpgradePlugin {
    private static final String OPTIONS_PROP = "options";
    private static final Pattern pattern = Pattern.compile("contentTaskOption['\"]");

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String deployment = (String)data.getPropertyValue("UPGRADE_FROM");
        if ("DEPLOYMENT".equals(deployment)) {
            return null;
        }
        String value = (String)data.getPropertyValue(OPTIONS_PROP);
        if (!this.needUpgrade(value)) {
            return null;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        try {
            String newValue = this.upgradeOptions(value);
            if (newValue == null) {
                return null;
            }
            result.setPropertyValue(OPTIONS_PROP, newValue);
            result.setUpgradeStatus(1);
        }
        catch (Exception e) {
            result.setMessage(e.getMessage());
            result.setUpgradeStatus(2);
        }
        return result;
    }

    private boolean needUpgrade(String value) {
        if (value == null) {
            return false;
        }
        Matcher m = pattern.matcher(value);
        return m.find();
    }

    private String upgradeOptions(String value) throws CMException {
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(value);
        XMLElement elProp = rootEl.getChild(0);
        if (elProp == null) {
            return null;
        }
        XMLElement propValue = elProp.getOptionalChildWithName("value");
        if (propValue == null || !propValue.hasChildren()) {
            return null;
        }
        boolean upgraded = false;
        for (XMLElement item : propValue.getChildren()) {
            String name;
            ContentTaskOption opt;
            if (!item.xsiType_.equals("contentTaskOption") || (opt = ContentTaskOption.forString(name = item.getChildValueWithName("name"))) == null) continue;
            item.xsiType_ = opt.getOptionType();
            upgraded = true;
        }
        if (!upgraded) {
            return null;
        }
        return elProp.makeXML(null, true, false, false);
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

