/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.caspian;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;

public class FixTenantsContentConflictResolutionOption
implements CMUpgradePlugin {
    private static final String OPTIONS_PROP = "options";
    private static final String OPTION_NAME = "tenantsContentConflictResolution";
    private static final String REPLACEMENT_VALUE = "keep";

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String value = (String)data.getPropertyValue(OPTIONS_PROP);
        if (!this.needUpgrade(value)) {
            return null;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        try {
            String newValue = this.upgradeValue(value);
            if (newValue == null) {
                return null;
            }
            result.setPropertyValue(OPTIONS_PROP, newValue);
            result.setUpgradeStatus(1);
        }
        catch (Exception e) {
            result.setMessage(e.getMessage());
            result.setUpgradeStatus(2);
        }
        return result;
    }

    private boolean needUpgrade(String value) {
        return value != null && -1 != value.indexOf(OPTION_NAME);
    }

    private String upgradeValue(String value) throws CMException {
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(value);
        XMLElement elProp = rootEl.getChild(0);
        if (elProp == null) {
            return null;
        }
        XMLElement propValue = elProp.getOptionalChildWithName("value");
        if (propValue == null || !propValue.hasChildren()) {
            return null;
        }
        boolean upgraded = false;
        for (XMLElement item : propValue.getChildren()) {
            XMLElement valueEl;
            String name = item.getChildValueWithName("name");
            if (!OPTION_NAME.equals(name) || (valueEl = item.getChildWithName("value")) == null || valueEl.value_ != null && !valueEl.value_.trim().isEmpty()) continue;
            valueEl.value_ = REPLACEMENT_VALUE;
            upgraded = true;
        }
        if (!upgraded) {
            return null;
        }
        return elProp.makeXML(null, true, false, false);
    }
}

