/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.colorado;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.dbstore.CMDbStoreUpgrade;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.util.CMDataUpgradeUtils;
import java.util.Collections;
import org.dom4j.Element;

public class AddDashboardCapabilities
implements CMUpgradePlugin {
    public static final String CANUSEDASHBOARDVIEWER_NAMEID_XML = "<nameID xsi:type=\"cm:stringProp\">\n    <value xsi:type=\"xsd:string\">cmInitCanUseDashboardViewer</value>\n</nameID>";
    public static final String SCRIPT_ADD_DASHBOARD_CAPS = "CMUpgradeScript_addDashboardCapabilities.xml";

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (CMDataUpgradeUtils.getIsFromDeployment(data)) {
            return null;
        }
        CMUpgradeResult result = null;
        try {
            Element canUseDashboardViewerEle = this.retrieveCanUseDashboardViewerFromCM();
            if (canUseDashboardViewerEle != null) {
                this.renameCanUseDashboardViewerCapability(canUseDashboardViewerEle);
            } else {
                CMDbStoreUpgrade.RunCMUpgradeScript(SCRIPT_ADD_DASHBOARD_CAPS);
            }
            result = CMUpgradeResultFactory.createSuccessUpgradeResult(Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            result = CMUpgradeResultFactory.createErrorUpgradeResult(e.getMessage());
        }
        return result;
    }

    private Element retrieveCanUseDashboardViewerFromCM() throws Exception {
        String response = this.queryCMForSecuredFunctions();
        Element queryResultEle = CMDataUpgradeUtils.parseResponse(response);
        Element canUseDashboardViewerEle = this.getCanUseDashboardViewerSecuredFunctionElment(queryResultEle);
        return canUseDashboardViewerEle;
    }

    private String queryCMForSecuredFunctions() throws Exception {
        String query2 = CMDataUpgradeUtils.buildQuery("/capability//securedFunction", new String[]{"userCapability", "searchPath"});
        String response = ContentManager.getInstance().ExecuteStaticRequest(query2, false, true);
        CMDataUpgradeUtils.validateResponse(response);
        return response;
    }

    private Element getCanUseDashboardViewerSecuredFunctionElment(Element queryResultEle) {
        Element dashboardSecuredFunction = (Element)queryResultEle.selectSingleNode("./item[userCapability/value='canUseDashboardViewer']");
        return dashboardSecuredFunction;
    }

    private void renameCanUseDashboardViewerCapability(Element canUseDashboardViewerEle) throws Exception {
        String searchPath = canUseDashboardViewerEle.valueOf("searchPath/value");
        if (searchPath == null) {
            throw new Exception("Error: No searchPath returned from query.");
        }
        String update2 = CMDataUpgradeUtils.buildUpdate(searchPath, "securedFunction", new String[]{CANUSEDASHBOARDVIEWER_NAMEID_XML});
        String response = ContentManager.getInstance().ExecuteStaticRequest(update2, false, true);
        CMDataUpgradeUtils.validateResponse(response);
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

