/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.colorado;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class UpdateExcelFormat
implements CMUpgradePlugin {
    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String options = null;
        CMUpgradeResult result = null;
        if (data != null) {
            options = (String)data.getPropertyValue("options");
        }
        if (this.isUpgradeRequired(options)) {
            String upgradedOptions = null;
            String errorMessage = null;
            try {
                upgradedOptions = this.upgradeOptions(options);
            }
            catch (Exception ex) {
                errorMessage = ex.getMessage();
            }
            if (errorMessage != null) {
                result = CMUpgradeResultFactory.createErrorUpgradeResult(errorMessage);
            } else if (upgradedOptions != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("options", upgradedOptions);
                result = CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
            } else {
                result = CMUpgradeResultFactory.createUpgradeNotRequiredResult();
            }
        } else {
            result = CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        }
        return result;
    }

    private boolean isUpgradeRequired(String options) {
        return options != null && options.indexOf("XLS") != -1;
    }

    private String upgradeOptions(String options) throws Exception {
        String upgradedOptionsXML = null;
        SAXReader reader = new SAXReader();
        boolean caseMultiOpFormatUpgrade = false;
        StringBuffer optionsWithRoot = new StringBuffer();
        optionsWithRoot.append("<root ").append(XMLElement.getCMPrefixes()).append(">").append(options).append("</root>");
        Document document = reader.read((Reader)new StringReader(optionsWithRoot.toString()));
        List nodes = document.getRootElement().selectNodes("/root/options/value/item[name=\"outputFormat\"]/value/item[.=\"XLS\" or .=\"singleXLS\" or .=\"XLWA\"]");
        if (!nodes.isEmpty()) {
            for (Node n : nodes) {
                if (!caseMultiOpFormatUpgrade) {
                    n.setText("XLWA");
                    caseMultiOpFormatUpgrade = true;
                    continue;
                }
                n.detach();
            }
            upgradedOptionsXML = CMXMLUtils.removeContainerElements(document.getRootElement().asXML(), 1);
        }
        return upgradedOptionsXML;
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

