/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.colorado;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class UpdateMruFolderRetentions
implements CMUpgradePlugin {
    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        boolean errorOccured = false;
        boolean retentionRuleUpdated = false;
        ArrayList<CMUpgradeMessage> errorMessages = new ArrayList<CMUpgradeMessage>();
        XMLElement elRetentions = null;
        try {
            String retentionsXMLString = (String)data.getPropertyValue("retentions");
            if (retentionsXMLString == null || retentionsXMLString.length() == 0) {
                return null;
            }
            XMLElement retentionsRootXML = CMXMLUtils.convertXMLString2XMLElement(retentionsXMLString);
            if (retentionsRootXML == null) {
                return null;
            }
            elRetentions = retentionsRootXML.getChild(0);
            if (elRetentions == null) {
                return null;
            }
            XMLElement elRetentionsArray = elRetentions.getChildWithName("value");
            if (elRetentionsArray == null || elRetentionsArray.children_ == null) {
                return null;
            }
            Iterator<XMLElement> it = elRetentionsArray.children_.iterator();
            boolean addURLRetentions = true;
            while (it.hasNext()) {
                int maxObj;
                XMLElement attrMaxObj;
                XMLElement elClassObj;
                XMLElement retentionRule = it.next();
                if (retentionRule == null || retentionRule.children_ == null || (elClassObj = retentionRule.getChildWithName("objectClass")) == null) continue;
                if (elClassObj.value_.equalsIgnoreCase("URL")) {
                    addURLRetentions = false;
                }
                if (!elClassObj.value_.equals("shortcut")) continue;
                XMLElement elProp = retentionRule.getChildWithName("prop");
                if (elProp != null && !elProp.value_.equals("modificationTime")) {
                    elProp.value_ = "modificationTime";
                    retentionRuleUpdated = true;
                }
                if ((attrMaxObj = retentionRule.getChildWithName("maxObjects")) == null || (maxObj = new Integer(attrMaxObj.value_).intValue()) >= 15) continue;
                maxObj = maxObj < 8 ? (maxObj += 7) : 15;
                attrMaxObj.value_ = new String("" + maxObj);
                retentionRuleUpdated = true;
            }
            if (addURLRetentions) {
                XMLElement retentionsArray = elRetentions.getChildWithName("value");
                this.addURLRetentions(retentionsArray);
                retentionRuleUpdated = true;
            }
        }
        catch (CMException e) {
            errorMessages.add(new CMUpgradeMessage(e.getMessage(), 40000));
            errorOccured = true;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorOccured) {
            result.setMessages(errorMessages);
            result.setUpgradeStatus(2);
            result.setNextAction(1);
        }
        if (!retentionRuleUpdated) {
            if (errorOccured) {
                return result;
            }
            return null;
        }
        String newRetentionsXMLString = elRetentions.makeXML(null, true, false, false);
        if (newRetentionsXMLString != null) {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put("retentions", newRetentionsXMLString);
            result.setData(upgradedData);
        }
        result.setUpgradeStatus(1);
        result.setNextAction(1);
        return result;
    }

    public void addURLRetentions(XMLElement retentions) {
        XMLElement itemElement2 = null;
        retentions.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "retentionRule", "URLitem");
        for (XMLElement itemElement2 : retentions.children_) {
            if (itemElement2 == null || itemElement2.value_ == null || !itemElement2.value_.equalsIgnoreCase("URLitem")) continue;
            itemElement2.value_ = null;
            itemElement2.addChild(null, "objectClass", CMSOAPConstants.NS_BIBUS, "classEnum", "URL");
            itemElement2.addChild(null, "prop", CMSOAPConstants.NS_BIBUS, "propEnum", "modificationTime");
            itemElement2.addChild(null, "maxObjects", CMSOAPConstants.NS_XMLSCHEMA, "integer", new String("15"));
            break;
        }
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

