/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.colorado;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public abstract class UpgradeFormatProperty
implements CMUpgradePlugin {
    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String format = null;
        CMUpgradeResult result = null;
        if (data != null) {
            format = (String)data.getPropertyValue(this.getPropertyName());
        }
        if (this.isUpgradeRequired(format)) {
            String upgradedFormat = null;
            String errorMessage = null;
            try {
                upgradedFormat = this.upgradeAccountFormat(format);
            }
            catch (Exception ex) {
                errorMessage = ex.getMessage();
            }
            if (errorMessage != null) {
                result = CMUpgradeResultFactory.createErrorUpgradeResult(errorMessage);
            } else if (upgradedFormat != null) {
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put(this.getPropertyName(), upgradedFormat);
                result = CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
            } else {
                result = CMUpgradeResultFactory.createUpgradeNotRequiredResult();
            }
        } else {
            result = CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        }
        return result;
    }

    private boolean isUpgradeRequired(String format) {
        return format != null && format.indexOf("XLS") != -1;
    }

    private String upgradeAccountFormat(String format) throws Exception {
        StringBuffer formatWithRoot = new StringBuffer();
        String upgradedAccountFormatXML = null;
        formatWithRoot.append("<root ").append(XMLElement.getCMPrefixes()).append(">").append(format).append("</root>");
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(formatWithRoot.toString()));
        Node n = document.getRootElement().selectSingleNode("//value");
        if (n != null && (n.getText().equals("XLS") || n.getText().equals("singleXLS"))) {
            n.setText("XLWA");
            upgradedAccountFormatXML = CMXMLUtils.removeContainerElements(document.getRootElement().asXML(), 1);
        }
        return upgradedAccountFormatXML;
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    protected abstract String getPropertyName();
}

