/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.colorado.midmarket;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class FilterCapabilityPolicies
implements CMUpgradePlugin {
    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (!CMDataUpgradeUtils.getIsFromDeployment(data)) {
            return null;
        }
        String policies = (String)data.getPropertyValue("userCapabilityPolicies");
        if (policies != null && policies.indexOf("canUseEV") != -1) {
            CMUpgradeResult result = new CMUpgradeResult();
            try {
                Document document = UpgradeUtils.parseXMLValue(policies);
                List nodes = document.selectNodes("//permissions/item[userCapability=\"canUseEV\"]");
                if (!nodes.isEmpty()) {
                    for (Node n : nodes) {
                        Element permissions = n.getParent();
                        n.detach();
                        if (permissions.elements().size() != 0) continue;
                        Element value = permissions.getParent().getParent();
                        permissions.getParent().detach();
                        if (value.elements().size() != 0) continue;
                        value.detach();
                        break;
                    }
                    HashMap<String, String> upgradedData = new HashMap<String, String>();
                    String newValue = CMXMLUtils.removeContainerElements(document.asXML(), 1);
                    upgradedData.put("userCapabilityPolicies", newValue);
                    result.setData(upgradedData);
                    result.setUpgradeStatus(1);
                }
            }
            catch (Exception e) {
                result.setMessage(e.getMessage());
                result.setUpgradeStatus(2);
            }
            return result;
        }
        return null;
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

