/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import java.util.Locale;

public class AddPolicies
implements CMUpgradePlugin {
    private static final String[] STRING_0 = new String[0];
    private static final String ATTR_ROLE_INITMSG = "roleInitMsg";
    private static final String ATTR_ACTIONS = "actions";
    Policy[] policies;

    Policy createPolicy(String roleInitMsgId, String actions) {
        return new Policy(roleInitMsgId, actions);
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        this.initPolicies(desc);
    }

    protected void initPolicies(CMPluginDescriptor desc) throws CMException {
        String param = (String)desc.getParameters().get("policies");
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(param);
        if (rootEl == null) {
            return;
        }
        XMLElement paramEl = rootEl.getChild(0);
        if (paramEl == null) {
            return;
        }
        this.policies = new Policy[paramEl.children_.size()];
        int i = 0;
        for (XMLElement itemEl : paramEl.children_) {
            String roleInitMsgId = itemEl.getAttribute(ATTR_ROLE_INITMSG);
            if (roleInitMsgId == null) {
                throw this.missingAttributeException(ATTR_ROLE_INITMSG);
            }
            String actions = itemEl.getAttribute(ATTR_ACTIONS);
            if (actions == null) {
                throw this.missingAttributeException(ATTR_ACTIONS);
            }
            this.policies[i++] = this.createPolicy(roleInitMsgId, actions);
        }
    }

    private CMException missingAttributeException(String attr) {
        return new CMException("cmExpectedAttributeMissing", new CMException.Parm("Name", attr), new CMException.Parm("Element", "item"));
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        if (UpgradeUtils.isMidmarket(data)) {
            return null;
        }
        return this.getUpgradeResult(data);
    }

    protected CMUpgradeResult getUpgradeResult(CMUpgradeData data) throws Exception {
        String errorMessage = null;
        String newPolicies = null;
        try {
            String oldPolicies = (String)data.getPropertyValue("policies");
            if (oldPolicies == null || oldPolicies.length() == 0) {
                return null;
            }
            newPolicies = this.addItemsToPolicies(oldPolicies, this.policies);
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else if (newPolicies == null) {
            result.setUpgradeStatus(0);
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put("policies", newPolicies);
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private String addItemsToPolicies(String policiesXMLString, Policy ... policies) throws CMException {
        XMLElement elPolicies = null;
        XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
        if (policiesRootXML == null) {
            return null;
        }
        elPolicies = policiesRootXML.getChild(0);
        if (elPolicies == null) {
            return null;
        }
        XMLElement elPolicyArray = elPolicies.getChildWithName("value");
        if (elPolicyArray == null || elPolicyArray.children_ == null) {
            return null;
        }
        boolean updated = this.updatePolicies(policiesXMLString, elPolicyArray, policies);
        return updated ? elPolicies.makeXML(null, true, false, false) : null;
    }

    boolean updatePolicies(String policiesXMLString, XMLElement elPolicyArray, Policy ... policies) {
        boolean updated = false;
        for (Policy policy : policies) {
            String searchPath = policy.getNewRoleSearchPath();
            if (policiesXMLString.indexOf(searchPath) != -1) continue;
            updated = true;
            CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, searchPath, policy.getPermissions());
        }
        return updated;
    }

    static class Policy {
        String roleInitMsg;
        String permissions;

        Policy(String roleInitMsg, String permissions) {
            this.roleInitMsg = roleInitMsg;
            this.permissions = permissions;
        }

        String getNewRoleSearchPath() {
            return "CAMID(\":" + CMError.getRLMessage(this.roleInitMsg, Locale.ENGLISH) + "\")";
        }

        String[] getPermissions() {
            return CMStringUtils.split(this.permissions, ',', true).toArray(STRING_0);
        }
    }
}

