/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cm.plugin.cm.upgrade.common.actions.Action;
import com.cognos.cm.plugin.cm.upgrade.common.actions.NullAction;
import com.cognos.cm.plugin.cm.upgrade.common.actions.RunScriptAction;
import com.cognos.cm.plugin.cm.upgrade.common.conditions.CapabilityExists;
import com.cognos.cm.plugin.cm.upgrade.common.conditions.Condition;
import com.cognos.cm.plugin.cm.upgrade.common.conditions.ObjectExists;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ConditionAndActionFactory {
    public static final String PARAM_CONDITION = "condition";
    public static final String CONDITION_CAPABILITYEXISTS = "capabilityExists";
    public static final String CONDITION_OBJECTEXISTS = "objectExists";
    public static final String ACTION_RUNSCRIPT = "runScript";

    public Condition getCondition(String conditionXml) throws Exception {
        Condition condition;
        Element root = this.getParameterValueElement(conditionXml);
        String conditionName = root.getName();
        if (CONDITION_CAPABILITYEXISTS.equals(conditionName)) {
            condition = new CapabilityExists();
        } else if (CONDITION_OBJECTEXISTS.equals(conditionName)) {
            condition = new ObjectExists();
        } else {
            throw new Exception("Unknown condition: '" + conditionName + "'");
        }
        condition.configure(root);
        return condition;
    }

    public Action getAction(String actionXml) throws Exception {
        if (null == actionXml) {
            return new NullAction();
        }
        Element root = this.getParameterValueElement(actionXml);
        String actionName = root.getName();
        if (!ACTION_RUNSCRIPT.equals(actionName)) {
            throw new Exception("Unkown action: '" + actionName + "'");
        }
        RunScriptAction action = new RunScriptAction();
        action.configure(root);
        return action;
    }

    private Element getParameterValueElement(String xml) throws Exception {
        Document doc = DocumentHelper.parseText((String)xml);
        Element paramEle = doc.getRootElement();
        Iterator elementIt = paramEle.elementIterator();
        if (!elementIt.hasNext()) {
            throw new Exception("Error parsing parameter, missing mandatory child element:\n" + xml);
        }
        return (Element)elementIt.next();
    }
}

