/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;

public class FilterUserCapabilityPolicies
implements CMUpgradePlugin {
    ArrayList<String> capabilities = new ArrayList();
    private String xpath;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        String param = (String)desc.getParameters().get("capabilities");
        ArrayList<String> list = CMStringUtils.split(param, ',');
        for (String s : list) {
            this.capabilities.add(s.trim());
        }
        if (!this.capabilities.isEmpty()) {
            this.xpath = this.getXPath();
        }
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (this.capabilities.isEmpty()) {
            return null;
        }
        String propValue = (String)data.getPropertyValue("userCapabilityPolicies");
        if (propValue == null) {
            return null;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        result.setUpgradeStatus(0);
        try {
            Document doc = UpgradeUtils.parseXMLValue(propValue);
            if (this.filterCapabilities(doc)) {
                this.updateResult(result, doc);
            }
        }
        catch (Exception e) {
            result.setMessage(e.getMessage());
            result.setUpgradeStatus(2);
        }
        return result;
    }

    private void updateResult(CMUpgradeResult result, Document doc) {
        HashMap<String, String> upgradedData = new HashMap<String, String>();
        String newValue = CMXMLUtils.removeContainerElements(doc.asXML(), 1);
        upgradedData.put("userCapabilityPolicies", newValue);
        result.setData(upgradedData);
        result.setUpgradeStatus(1);
    }

    private boolean filterCapabilities(Document doc) {
        boolean upgraded = false;
        for (Node node : doc.selectNodes(this.xpath)) {
            upgraded = true;
            Element permissions = node.getParent();
            node.detach();
            if (permissions.elements().size() != 0) continue;
            Element value = permissions.getParent().getParent();
            permissions.getParent().detach();
            if (value.elements().size() != 0) continue;
            value.detach();
            break;
        }
        return upgraded;
    }

    private String getXPath() {
        StringBuilder buf = new StringBuilder("//permissions/*[userCapability=\"");
        String separator = "";
        for (String capability : this.capabilities) {
            buf.append(separator);
            buf.append(capability).append('\"');
            separator = " or userCapability=\"";
        }
        buf.append(']');
        return buf.toString();
    }

    public void terminate() throws Exception {
    }
}

