/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class FixOptionValueType
implements CMUpgradePlugin {
    private static final String PROP_NAME = "options";
    private ArrayList<Patch> patches;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        String xml = (String)desc.getParameters().get("patches");
        Element root = DocumentHelper.parseText((String)xml).getRootElement();
        List children = root.elements();
        this.patches = new ArrayList(children.size());
        for (Element item : children) {
            Patch patch = new Patch();
            List attrs = item.attributes();
            for (Attribute attr : attrs) {
                String name = attr.getName();
                Field f = Patch.class.getDeclaredField(name);
                f.set(patch, attr.getStringValue());
            }
            if (patch.lookup == null) {
                patch.lookup = patch.type;
            }
            if (!this.parseReplaceValue(patch)) {
                throw new CMException("cmInvalidObjectClass", new CMException.Parm("Class", patch.replace));
            }
            this.patches.add(patch);
        }
    }

    private boolean parseReplaceValue(Patch patch) {
        int i = patch.replace.indexOf(":");
        if (i == -1) {
            return false;
        }
        String prefix = patch.replace.substring(0, i);
        if (prefix.equals("xsd")) {
            patch.replaceNs = CMSOAPConstants.NS_XMLSCHEMA;
        } else if (prefix.equals("bus")) {
            patch.replaceNs = CMSOAPConstants.NS_BIBUS;
        } else {
            return false;
        }
        patch.replace = patch.replace.substring(i + 1);
        return true;
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String value = (String)data.getPropertyValue(PROP_NAME);
        if (!this.needUpgrade(value)) {
            return null;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        try {
            String newValue = this.upgradeOptions(value);
            if (newValue == null) {
                return null;
            }
            result.setPropertyValue(PROP_NAME, newValue);
            result.setUpgradeStatus(1);
        }
        catch (Exception e) {
            result.setMessage(e.getMessage());
            result.setUpgradeStatus(2);
        }
        return result;
    }

    private boolean needUpgrade(String value) {
        if (value == null) {
            return false;
        }
        for (Patch item : this.patches) {
            if (value.indexOf(item.lookup) == -1) continue;
            return true;
        }
        return false;
    }

    private String upgradeOptions(String value) throws Exception {
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(value);
        XMLElement elProp = rootEl.getChild(0);
        if (elProp == null) {
            return null;
        }
        XMLElement propValue = elProp.getOptionalChildWithName("value");
        if (propValue == null || !propValue.hasChildren()) {
            return null;
        }
        boolean upgraded = false;
        block0: for (XMLElement el : propValue.getChildren()) {
            for (Patch patch : this.patches) {
                XMLElement itemValue;
                if (!patch.type.equals(el.xsiType_) || (itemValue = el.getOptionalChildWithName("value")) == null || patch.match != null && !patch.match.equals(itemValue.xsiType_)) continue;
                itemValue.xsiType_ = patch.replace;
                itemValue.xsiTypeNs_ = patch.replaceNs;
                upgraded = true;
                continue block0;
            }
        }
        if (!upgraded) {
            return null;
        }
        return elProp.makeXML(null, true, false, false);
    }

    public void terminate() throws Exception {
    }

    static class Patch {
        String lookup;
        String type;
        String match;
        String replace;
        CMSOAPConstants.XMLNamespace replaceNs;

        Patch() {
        }
    }
}

