/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.common.ConditionAndActionFactory;
import com.cognos.cm.plugin.cm.upgrade.common.actions.Action;
import com.cognos.cm.plugin.cm.upgrade.common.conditions.Condition;
import com.cognos.cm.plugin.cm.upgrade.common.conditions.Unless;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.util.CMDataUpgradeUtils;
import java.util.Collections;
import java.util.Map;

public class IfThenElse
implements CMUpgradePlugin {
    public static final String PARAM_IF = "if";
    public static final String PARAM_UNLESS = "unless";
    public static final String PARAM_THEN = "then";
    public static final String PARAM_ELSE = "else";
    private ConditionAndActionFactory conditionAndActionFactory;
    private Condition ifCondition;
    private Action thenAction;
    private Action elseAction;

    public IfThenElse(ConditionAndActionFactory conditionAndActionFactory) {
        this.conditionAndActionFactory = conditionAndActionFactory;
    }

    public IfThenElse() {
        this(new ConditionAndActionFactory());
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        this.initializeCondition(desc);
        this.initializeActions(desc);
    }

    private void initializeCondition(CMPluginDescriptor desc) throws Exception {
        String ifString = desc.getParameter(PARAM_IF);
        String unlessString = desc.getParameter(PARAM_UNLESS);
        if (null == ifString && null == unlessString) {
            throw new Exception("One of the parameters 'if' or 'unless' must be defined.");
        }
        if (null != ifString && null != unlessString) {
            throw new Exception("Only one of the parameters 'if' or 'unless' may be defined.");
        }
        boolean isUnless = null != unlessString;
        this.ifCondition = this.conditionAndActionFactory.getCondition(isUnless ? unlessString : ifString);
        if (isUnless) {
            this.ifCondition = new Unless(this.ifCondition);
        }
    }

    private void initializeActions(CMPluginDescriptor desc) throws Exception {
        String thenString = desc.getParameter(PARAM_THEN);
        String elseString = desc.getParameter(PARAM_ELSE);
        this.thenAction = this.conditionAndActionFactory.getAction(thenString);
        this.elseAction = this.conditionAndActionFactory.getAction(elseString);
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (CMDataUpgradeUtils.getIsFromDeployment(data)) {
            return null;
        }
        CMUpgradeResult result = null;
        try {
            if (this.ifCondition.isConditionMet()) {
                this.thenAction.execute();
            } else {
                this.elseAction.execute();
            }
            Map<String, String> empty = Collections.emptyMap();
            result = CMUpgradeResultFactory.createSuccessUpgradeResult(empty);
        }
        catch (Exception e) {
            result = CMUpgradeResultFactory.createErrorUpgradeResult(e.getMessage());
        }
        return result;
    }

    public void terminate() throws Exception {
    }

    public Condition getCondition() {
        return this.ifCondition;
    }
}

