/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MapPropValue
implements CMUpgradePlugin {
    Properties propMap = new Properties();
    String propName = null;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        String mapFile = (String)desc.getParameters().get("mapFile");
        if (mapFile != null) {
            this.loadPropertiesFromFile(mapFile);
        } else {
            mapFile = (String)desc.getParameters().get("map");
            this.loadPropertiesFromString(mapFile);
        }
        this.propName = (String)desc.getProperties().get(0);
    }

    private void loadPropertiesFromString(String value) {
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((Reader)new StringReader(value));
            for (Element el : doc.getRootElement().elements()) {
                this.propMap.put(el.attributeValue("key"), el.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPropertiesFromFile(String name) throws CMException {
        block8: {
            CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
            InputStream stream = resourceLoader.getResourceInputStream(name);
            if (stream == null) {
                throw new CMException("cmNoConfigScript", new CMException.Parm("Script", name));
            }
            try {
                if (name.endsWith(".properties")) {
                    this.propMap.load(stream);
                    break block8;
                }
                if (name.endsWith(".xml")) {
                    this.propMap.loadFromXML(stream);
                    break block8;
                }
                throw new CMException("cmBadConfigFile", new CMException.Parm("File", name));
            }
            catch (IOException e) {
                throw new CMException((Exception)e, "cmBadConfigFile", new CMException.Parm("File", name));
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String newValue;
        if (this.propName == null) {
            return null;
        }
        CMUpgradeResult result = null;
        String propValue = (String)data.getPropertyValue(this.propName);
        if (propValue == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<root ").append(XMLElement.getCMPrefixes()).append(">").append(propValue).append("</root>");
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(buf.toString()));
        Node node = document.getRootElement().selectSingleNode("//value");
        String oldValue = node.getText();
        if (oldValue != null && oldValue.length() != 0 && (newValue = this.propMap.getProperty(oldValue)) != null) {
            node.setText(newValue);
            propValue = CMXMLUtils.removeContainerElements(document.getRootElement().asXML(), 1);
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put(this.propName, propValue);
            result = CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
        }
        return result;
    }

    public void terminate() throws Exception {
    }
}

