/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.util.CMDataUpgradeUtils;
import java.util.HashMap;

public class RenameCapability
implements CMUpgradePlugin {
    private static final String PROP_NAME = "name";
    private static final String PROP_DESCRIPTION = "description";
    private String capability;
    private String nameId;
    private String descriptionId;

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        try {
            String newValue;
            String oldValue;
            String userCapabilityVal = CMDataUpgradeUtils.getPropertyValue(data, "userCapability");
            if (!this.capability.equals(userCapabilityVal)) {
                return null;
            }
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            if (this.nameId != null) {
                oldValue = (String)data.getPropertyValue(PROP_NAME);
                newValue = UpgradeUtils.updateName(oldValue, this.nameId);
                upgradedData.put(PROP_NAME, newValue);
            }
            if (this.descriptionId != null) {
                oldValue = (String)data.getPropertyValue(PROP_DESCRIPTION);
                newValue = UpgradeUtils.updateName(oldValue, this.descriptionId);
                upgradedData.put(PROP_DESCRIPTION, newValue);
            }
            return CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
        }
        catch (Exception e) {
            return CMUpgradeResultFactory.createErrorUpgradeResult(e.getMessage());
        }
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        this.capability = (String)desc.getParameters().get("capability");
        this.nameId = desc.getParameter("nameId");
        this.descriptionId = desc.getParameter("descriptionId");
    }

    public void terminate() throws Exception {
    }
}

