/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.plugin.cm.upgrade.utils.PathMatcher;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDataUpgradeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class ReplaceStringInPropertyValue
implements CMUpgradePlugin {
    private Map<String, String> parameterNameValuePair;
    private Map<String, ArrayList<PathMatcher>> pathMatchersForObjectClass;
    private List<String> searchPaths;

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        try {
            Object upgradeFromPropertyValue = data.getPropertyValue("UPGRADE_FROM");
            boolean upgradeIsForDeployment = "DEPLOYMENT".equals(upgradeFromPropertyValue);
            if (upgradeIsForDeployment) {
                return this.performUpgradeForDeployment(data);
            }
            return this.performUpgradeForDB(data);
        }
        catch (Exception e) {
            return CMUpgradeResultFactory.createErrorUpgradeResult(e.getMessage());
        }
    }

    private CMUpgradeResult performUpgradeForDB(CMUpgradeData data) throws DocumentException {
        return this.performUpgrade(data);
    }

    private CMUpgradeResult performUpgradeForDeployment(CMUpgradeData data) throws Exception {
        if (this.pathMatchersForObjectClass == null) {
            this.initMatchers(this.searchPaths);
        }
        String objectClass = CMDataUpgradeUtils.getPropertyValue(data, "objectClass");
        ArrayList<PathMatcher> matchers = this.pathMatchersForObjectClass.get(objectClass);
        String searchPath = CMDataUpgradeUtils.getPropertyValue(data, "searchPath");
        if (searchPath == null) {
            return null;
        }
        CMStoreXPath path = new CMStoreXPath(searchPath);
        for (PathMatcher matcher : matchers) {
            if (!matcher.matches(path)) continue;
            return this.performUpgrade(data);
        }
        return null;
    }

    private void initMatchers(List<String> searchPaths) throws CMException {
        this.pathMatchersForObjectClass = new HashMap<String, ArrayList<PathMatcher>>();
        for (String searchPath : searchPaths) {
            PathMatcher matcher = new PathMatcher(searchPath);
            ArrayList<PathMatcher> list = this.pathMatchersForObjectClass.get(matcher.getObjectClass());
            if (list == null) {
                list = new ArrayList();
                this.pathMatchersForObjectClass.put(matcher.getObjectClass(), list);
            }
            list.add(matcher);
        }
    }

    private CMUpgradeResult performUpgrade(CMUpgradeData data) throws DocumentException {
        String propertyName = this.parameterNameValuePair.get("propertyName");
        String stringToRemoveFromValue = this.parameterNameValuePair.get("stringToRemove");
        String stringToReplaceWith = this.parameterNameValuePair.get("stringToReplaceWith");
        if (!data.getProperties().contains(propertyName)) {
            return CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        }
        String propertyXMLStr = (String)data.getPropertyValue(propertyName);
        Document propertyXMLDoc = UpgradeUtils.parseXMLValue(propertyXMLStr);
        Element root = propertyXMLDoc.getRootElement();
        Element propertyElement = (Element)root.elements().get(0);
        if (propertyElement.elements().isEmpty()) {
            return CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        }
        Element propertyValueElement = (Element)propertyElement.elements().get(0);
        String oldPropertyValueString = propertyValueElement.getText();
        String newPropertyValueString = oldPropertyValueString.replaceAll(stringToRemoveFromValue, stringToReplaceWith);
        propertyValueElement.setText(newPropertyValueString);
        CMUpgradeResult result = CMUpgradeResultFactory.createSuccessUpgradeResult(new HashMap<String, String>());
        result.setPropertyValue(propertyName, propertyElement.asXML());
        return result;
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        this.parameterNameValuePair = desc.getParameters();
        this.searchPaths = desc.getSearchPaths();
    }

    public void terminate() throws Exception {
    }
}

