/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RetranslateCapabilityName
implements CMUpgradePlugin {
    private static final String ATTR_CAPABILITY = "userCapability";
    private static final String ATTR_LOCALE = "locale";
    private static final String ATTR_OLD = "old";
    private static final String ATTR_NEW = "new";
    HashMap<String, Translation> localeMap = null;
    HashMap<String, Map<String, Translation>> translations = new HashMap();

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        String param = (String)desc.getParameters().get("translations");
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(param);
        if (rootEl == null) {
            return;
        }
        XMLElement paramEl = rootEl.getChild(0);
        if (paramEl == null) {
            return;
        }
        for (XMLElement itemEl : paramEl.children_) {
            String capability = itemEl.getAttribute(ATTR_CAPABILITY);
            if (capability == null) {
                throw this.missingAttributeException(ATTR_CAPABILITY);
            }
            String locale = itemEl.getAttribute(ATTR_LOCALE);
            if (locale == null) {
                throw this.missingAttributeException(ATTR_LOCALE);
            }
            String oldTrans = itemEl.getAttribute(ATTR_OLD);
            if (oldTrans == null) {
                throw this.missingAttributeException(ATTR_OLD);
            }
            String stringId = itemEl.getAttribute(ATTR_NEW);
            if (stringId == null) {
                throw this.missingAttributeException(ATTR_NEW);
            }
            if (this.translations.get(capability) == null) {
                this.localeMap = new HashMap();
                this.localeMap.put(locale, new Translation(oldTrans, stringId));
                this.translations.put(capability, this.localeMap);
                continue;
            }
            Map<String, Translation> tranEntry = this.translations.get(capability);
            tranEntry.put(locale, new Translation(oldTrans, stringId));
            this.translations.put(capability, tranEntry);
        }
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (this.translations.isEmpty()) {
            return null;
        }
        String userCapXML = (String)data.getPropertyValue(ATTR_CAPABILITY);
        String nameXML = (String)data.getPropertyValue("name");
        if (userCapXML == null || userCapXML.length() == 0 || nameXML == null || nameXML.length() == 0) {
            return null;
        }
        String userCapabilityVal = CMDataUpgradeUtils.getPropertyValue(data, ATTR_CAPABILITY);
        Map<String, Translation> transSource = this.translations.get(userCapabilityVal);
        if (transSource == null) {
            return null;
        }
        XMLElement rootNameEl = CMXMLUtils.convertXMLString2XMLElement(nameXML);
        if (rootNameEl == null) {
            return null;
        }
        XMLElement nameEl = rootNameEl.getChild(0);
        if (nameEl == null) {
            return null;
        }
        boolean upgraded = false;
        XMLElement nameValueEl = nameEl.getChildWithName("value");
        for (XMLElement itemEl : nameValueEl.children_) {
            XMLElement localeEl = itemEl.getChildWithName(ATTR_LOCALE);
            XMLElement valueEl = itemEl.getChildWithName("value");
            String locale = localeEl.value_;
            Translation tr = transSource.get(locale);
            if (tr == null || !tr.oldTranslation_.equals(valueEl.value_)) continue;
            valueEl.value_ = tr.newTranslation_;
            upgraded = true;
        }
        if (!upgraded) {
            return null;
        }
        nameXML = nameEl.makeXML("", true, false, false);
        CMUpgradeResult result = new CMUpgradeResult();
        Hashtable<String, String> update2 = new Hashtable<String, String>();
        result.setNextAction(1);
        result.setUpgradeStatus(1);
        result.setData(update2);
        update2.put("name", nameXML);
        return result;
    }

    private CMException missingAttributeException(String attr) {
        return new CMException("cmExpectedAttributeMissing", new CMException.Parm("Name", attr), new CMException.Parm("Element", "item"));
    }

    private class Translation {
        private String oldTranslation_;
        private String newTranslation_;

        private Translation(String oldTrans, String newTrans) {
            this.oldTranslation_ = oldTrans;
            this.newTranslation_ = newTrans;
        }
    }
}

