/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import java.util.Hashtable;

public class RetranslateName
implements CMUpgradePlugin {
    private static final String ATTR_LOCALE = "locale";
    private static final String ATTR_OLD = "old";
    private static final String ATTR_NEW = "new";
    HashMap<String, Translation> translations = new HashMap();

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        String param = (String)desc.getParameters().get("translations");
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(param);
        if (rootEl == null) {
            return;
        }
        XMLElement paramEl = rootEl.getChild(0);
        if (paramEl == null) {
            return;
        }
        for (XMLElement itemEl : paramEl.children_) {
            String locale = itemEl.getAttribute(ATTR_LOCALE);
            if (locale == null) {
                throw this.missingAttributeException(ATTR_LOCALE);
            }
            String oldTrans = itemEl.getAttribute(ATTR_OLD);
            if (oldTrans == null) {
                throw this.missingAttributeException(ATTR_OLD);
            }
            String newTrans = itemEl.getAttribute(ATTR_NEW);
            if (newTrans == null) {
                throw this.missingAttributeException(ATTR_NEW);
            }
            this.translations.put(locale, new Translation(oldTrans, newTrans));
        }
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (this.translations.isEmpty()) {
            return null;
        }
        String nameXml = (String)data.getPropertyValue("name");
        if (nameXml == null) {
            return null;
        }
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(nameXml);
        if (rootEl == null) {
            return null;
        }
        XMLElement nameEl = rootEl.getChild(0);
        if (nameEl == null) {
            return null;
        }
        boolean upgraded = false;
        XMLElement nameValueEl = nameEl.getChildWithName("value");
        for (XMLElement itemEl : nameValueEl.children_) {
            XMLElement localeEl = itemEl.getChildWithName(ATTR_LOCALE);
            XMLElement valueEl = itemEl.getChildWithName("value");
            Translation tr = this.translations.get(localeEl.value_);
            if (tr == null || !tr.oldTranslation.equals(valueEl.value_)) continue;
            valueEl.value_ = tr.newTranslation;
            upgraded = true;
        }
        if (!upgraded) {
            return null;
        }
        nameXml = nameEl.makeXML("", true, false, false);
        CMUpgradeResult result = new CMUpgradeResult();
        Hashtable<String, String> update2 = new Hashtable<String, String>();
        result.setNextAction(1);
        result.setUpgradeStatus(1);
        result.setData(update2);
        update2.put("name", nameXml);
        return result;
    }

    public void terminate() throws Exception {
    }

    private CMException missingAttributeException(String attr) {
        return new CMException("cmExpectedAttributeMissing", new CMException.Parm("Name", attr), new CMException.Parm("Element", "item"));
    }

    private class Translation {
        private String oldTranslation;
        private String newTranslation;

        private Translation(String oldTrans, String newTrans) {
            this.oldTranslation = oldTrans;
            this.newTranslation = newTrans;
        }
    }
}

