/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMPropertyTypeRender;
import com.cognos.cm.properties.CMRetentionRule;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMDataUpgradeUtils;
import java.util.ArrayList;
import java.util.HashMap;

public class SetDefaultRetentions
implements CMUpgradePlugin {
    private static final String RETENTIONS = "retentions";

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        CMUpgradeResult result;
        if (data == null) {
            return null;
        }
        String retentions = null;
        String errorMessage = null;
        try {
            retentions = (String)data.getPropertyValue(RETENTIONS);
            if (retentions != null) {
                return null;
            }
            String className = CMDataUpgradeUtils.getPropertyValue(data, "objectClass");
            ArrayList<CMRetentionRule> rules = this.getDefaultRetentionRules(className);
            if (rules == null) {
                return null;
            }
            retentions = this.renderAsXML(rules);
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        if (errorMessage != null) {
            result = CMUpgradeResultFactory.createErrorUpgradeResult(errorMessage);
        } else if (retentions == null) {
            result = CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put(RETENTIONS, retentions);
            result = CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
        }
        return result;
    }

    private String renderAsXML(ArrayList<CMRetentionRule> rules) {
        StringBuilder buf = new StringBuilder();
        buf.append("<retentions xsi:type=\"cm:retentionRuleArrayProp\">");
        buf.append("<value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:retentionRule[");
        buf.append(rules.size());
        buf.append("]\">");
        for (CMRetentionRule rule : rules) {
            buf.append("<item xsi:type=\"cm:retentionRule\">");
            buf.append(CMPropertyTypeRender.renderRetentionRuleAsXML(rule));
            buf.append("</item>");
        }
        buf.append("</value></retentions>");
        return buf.toString();
    }

    private ArrayList<CMRetentionRule> getDefaultRetentionRules(String className) {
        CMObjectClass cls = CMDbStoreFactory.getObjectClasses().getClassByName(className);
        if (cls == null) {
            return null;
        }
        ArrayList<CMRetentionRule> result = cls.getDefaultRetentionRules();
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }
}

