/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.common;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class UpdateCapabilityPolicies
implements CMUpgradePlugin {
    protected HashMap<String, CapabilityData> capabilityDataObjs_ = new HashMap();
    protected static final String ATTR_CAPABILITYENUM = "capEnum";
    protected static final String ATTR_ROLE_INITMSG = "roleInitMsg";
    protected static final String ATTR_ACTIONS = "actions";

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        String param = (String)desc.getParameters().get("capabilities");
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(param);
        if (rootEl == null) {
            return;
        }
        XMLElement paramEl = rootEl.getChild(0);
        if (paramEl == null) {
            return;
        }
        for (XMLElement itemEl : paramEl.children_) {
            String userCapabilityEnum = itemEl.getAttribute(ATTR_CAPABILITYENUM);
            if (userCapabilityEnum == null) {
                throw this.missingAttributeException(ATTR_CAPABILITYENUM);
            }
            String roleInitMsgId = itemEl.getAttribute(ATTR_ROLE_INITMSG);
            if (roleInitMsgId == null) {
                throw this.missingAttributeException(ATTR_ROLE_INITMSG);
            }
            String actions = itemEl.getAttribute(ATTR_ACTIONS);
            if (actions == null) {
                throw this.missingAttributeException(ATTR_ACTIONS);
            }
            this.capabilityDataObjs_.put(userCapabilityEnum, new CapabilityData(roleInitMsgId, actions));
        }
    }

    protected CMException missingAttributeException(String attr) {
        return new CMException("cmExpectedAttributeMissing", new CMException.Parm("Name", attr), new CMException.Parm("Element", "item"));
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        if (UpgradeUtils.isMidmarket(data)) {
            return null;
        }
        String errorMessage = null;
        String newPoliciesXMLString = null;
        try {
            String userCapabilityVal = CMDataUpgradeUtils.getPropertyValue(data, "userCapability");
            String userCapEnum = this.findCapabilityToUpgrade(userCapabilityVal);
            if (userCapEnum == null) {
                return null;
            }
            String policiesXMLString = (String)data.getPropertyValue("policies");
            if (policiesXMLString == null) {
                return null;
            }
            newPoliciesXMLString = this.getUpdatedPolicies(userCapEnum, policiesXMLString);
            if (newPoliciesXMLString == null) {
                return null;
            }
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        return this.createUpgradeResult(errorMessage, newPoliciesXMLString);
    }

    protected String getUpdatedPolicies(String userCapEnum, String policiesXMLString) throws CMException {
        CapabilityData capData = this.capabilityDataObjs_.get(userCapEnum);
        String roleCAMID = capData.getNewRoleSearchPath();
        if (policiesXMLString.indexOf(roleCAMID) != -1) {
            return null;
        }
        return this.addItemsToPolicies(policiesXMLString, roleCAMID, capData.getActions());
    }

    private CMUpgradeResult createUpgradeResult(String errorMessage, String newPoliciesXMLString) {
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else if (newPoliciesXMLString == null) {
            result.setUpgradeStatus(0);
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put("policies", newPoliciesXMLString);
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    protected String findCapabilityToUpgrade(String userCapabilityVal) {
        String capEnumToUpgrade = null;
        if (userCapabilityVal != null) {
            Set<String> capEnums = this.capabilityDataObjs_.keySet();
            for (String cap : capEnums) {
                if (!userCapabilityVal.equals(cap)) continue;
                capEnumToUpgrade = cap;
                break;
            }
        }
        return capEnumToUpgrade;
    }

    private String addItemsToPolicies(String policiesXMLString, String roleCAMID, String[] actions) throws CMException {
        XMLElement elPolicies = null;
        XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
        if (policiesRootXML == null) {
            return null;
        }
        elPolicies = policiesRootXML.getChild(0);
        if (elPolicies == null) {
            return null;
        }
        XMLElement elPolicyArray = elPolicies.getChildWithName("value");
        if (elPolicyArray == null || elPolicyArray.children_ == null) {
            return null;
        }
        CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, roleCAMID, actions);
        String newPoliciesXMLString = elPolicies.makeXML(null, true, false, false);
        return newPoliciesXMLString;
    }

    public class CapabilityData {
        private String roleInitMsg;
        private String permissions;
        private String access = "grant";

        private CapabilityData(String roleInitMsg, String permissions) {
            this.roleInitMsg = roleInitMsg;
            this.permissions = permissions;
        }

        public CapabilityData(String roleInitMsg, String permissions, String access) {
            this.roleInitMsg = roleInitMsg;
            this.permissions = permissions;
            this.access = access;
        }

        public String getNewRoleSearchPath() {
            return "CAMID(\":" + CMError.getRLMessage(this.roleInitMsg, Locale.ENGLISH) + "\")";
        }

        public String[] getActions() {
            String[] actions = this.permissions.split(",");
            return actions;
        }

        public String getAccess() {
            return this.access;
        }
    }
}

