/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.endor;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.locking.ICMLockManager;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.properties.CMBasePropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SmartsModuleUpgrade
implements CMUpgradePlugin {
    public static final String SMARTS_CLASS = "com.ibm.smarts.ca.upgrade.analytics.ModuleAnalyticsMigrator";
    public static final String ANALYTICS = "analytics";
    public static final String BASEANALYTICS = "baseAnalytics";
    public static final String BASEDEFINITION = "baseDefinition";
    public static final String DEFAULT_NAME = "defaultName";
    public static final String DEFINITION = "definition";
    public static final String PARENTID = "parentID";
    public static final String SEARCHPATH = "searchPath";
    public static final String SMARTS_DATA = "smartsData";
    public static final String STOREID = "storeID";
    public static final String TENANTID = "tenantID";
    public static final String TAGS = "tags";
    protected ICMLockManager lockManager;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        CMStorePath storePath = null;
        CMException exception = null;
        String message = null;
        boolean emptySmartsModule = false;
        HashMap<String, String> moduleProperties = new HashMap();
        CMStore store = CMExecutionContext.get().getStore();
        CMProperty[] properties = new CMProperty[]{CMObjectClass.MODULE.getProperty(ANALYTICS), CMObjectClass.BASEMODULE.getProperty(BASEANALYTICS), CMProperty.STOREID, CMObjectClass.MODULE.getProperty(DEFINITION), CMObjectClass.BASEMODULE.getProperty(BASEDEFINITION), CMProperty.TENANTID};
        String searchPath = CMDataUpgradeUtils.getPropertyValue(data, SEARCHPATH);
        if (searchPath == null) {
            return null;
        }
        storePath = CMStoreXPath.parse(searchPath);
        try {
            storePath.setLockManagerUsageFlag(11);
            this.lockManager = store.getLockManager();
            this.lockManager.requestLocks(storePath);
            store.beginTransaction();
            moduleProperties = this.queryObject(store, properties, searchPath);
            if (moduleProperties != null) {
                List<Map<String, Object>> smartsObjects = this.getSmartsObjects(moduleProperties);
                if (!smartsObjects.isEmpty()) {
                    int parentID = Integer.valueOf((String)moduleProperties.get(PARENTID));
                    String tenantID = (String)moduleProperties.get(TENANTID);
                    for (Map<String, Object> objList : smartsObjects) {
                        String objName = (String)objList.get(DEFAULT_NAME);
                        this.createSmartsModule(store, parentID, tenantID, objName, CMObjectClass.SMARTSMODULE, objList);
                    }
                    store.commitTransaction();
                } else {
                    emptySmartsModule = true;
                }
            }
        }
        catch (CMException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            message = ex.getMessage();
            if (message == null) {
                message = ex.toString();
            }
        }
        finally {
            this.release(store);
        }
        if (emptySmartsModule) {
            return CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        }
        if (exception != null) {
            if (exception.getCode().equalsIgnoreCase("cmDuplicateObject")) {
                return CMUpgradeResultFactory.createUpgradeNotRequiredResult();
            }
            message = exception.getMessage();
            return CMUpgradeResultFactory.createErrorUpgradeResult(message);
        }
        if (message != null) {
            return CMUpgradeResultFactory.createErrorUpgradeResult(message);
        }
        return CMUpgradeResultFactory.createSuccessUpgradeResult(Collections.EMPTY_MAP);
    }

    private Map<String, String> queryObject(CMStore store, CMProperty[] properties, String searchPath) throws Exception {
        CMStoreQueryResults queryResult = null;
        try {
            HashMap<String, String> moduleProps = new HashMap<String, String>();
            queryResult = store.executeQuery(searchPath, properties, null, 0, 512, null);
            if (queryResult.next()) {
                CMObjectClass objectClass = queryResult.getObjectClass();
                if (objectClass.equals(CMObjectClass.MODULE)) {
                    moduleProps.put(ANALYTICS, this.extractValue(queryResult, 0));
                    moduleProps.put(DEFINITION, this.extractValue(queryResult, 3));
                }
                if (objectClass.equals(CMObjectClass.BASEMODULE)) {
                    moduleProps.put(ANALYTICS, this.extractValue(queryResult, 1));
                    moduleProps.put(DEFINITION, this.extractValue(queryResult, 4));
                }
            } else {
                Map<String, String> map = null;
                return map;
            }
            moduleProps.put(STOREID, this.extractValue(queryResult, 2));
            moduleProps.put(TENANTID, this.extractValue(queryResult, 5));
            moduleProps.put(PARENTID, Integer.toString(queryResult.getObjectID()));
            HashMap<String, String> hashMap = moduleProps;
            return hashMap;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (queryResult != null) {
                queryResult.release();
            }
        }
    }

    private String extractValue(CMStoreQueryResults queryResults, int index) throws CMException, IOException {
        Object value = null;
        String svalue = null;
        value = queryResults.getValue(index);
        if (value instanceof Reader) {
            svalue = CMStreamUtils.readReaderIntoString((Reader)((Reader)value));
        } else if (value != null) {
            svalue = value.toString();
        }
        return svalue != null && svalue.length() > 0 ? svalue : " ";
    }

    private List<Map<String, Object>> getSmartsObjects(Map<String, String> moduleProp) throws Exception {
        ArrayList<Map<String, Object>> smartsObjects = new ArrayList();
        String analytics = null;
        String moduleDefinitation = null;
        String moduleStoreID = null;
        analytics = moduleProp.get(ANALYTICS);
        moduleDefinitation = moduleProp.get(DEFINITION);
        moduleStoreID = moduleProp.get(STOREID).toString();
        smartsObjects = this.invoke(moduleStoreID, moduleDefinitation, analytics);
        return smartsObjects;
    }

    private void createSmartsModule(CMStore store, int parentID, String tenantID, String name, CMObjectClass objClass, Map<String, Object> properties) throws Exception {
        ArrayList<CMProperty> smartsModuleProps = new ArrayList<CMProperty>();
        ArrayList<Object> smartsModulePropsValues = new ArrayList<Object>();
        smartsModuleProps.add(CMProperty.TENANTID);
        smartsModulePropsValues.add(tenantID);
        try {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                smartsModuleProps.add(CMObjectClass.SMARTSMODULE.getProperty(entry.getKey()));
                if (entry.getKey().equalsIgnoreCase(TAGS)) {
                    String[] tagStrArr;
                    CMDbStoreStringArray cmTagsStrArr = new CMDbStoreStringArray();
                    for (String tagStr : tagStrArr = (String[])entry.getValue()) {
                        cmTagsStrArr.add(tagStr);
                    }
                    smartsModulePropsValues.add(cmTagsStrArr);
                    continue;
                }
                smartsModulePropsValues.add(entry.getValue());
            }
            store.addObject(parentID, (CMBasePropertyValue)new CMDbStoreString(name), objClass, smartsModuleProps, smartsModulePropsValues);
        }
        catch (Exception ex) {
            CMIndications.logException(ex);
            throw ex;
        }
    }

    private void release(CMStore store) {
        try {
            if (store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.lockManager.releaseLocks();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<Map<String, Object>> invoke(String moduleStoreID, String moduleDefinitation, String analytics) throws Exception {
        List smartsObjectsNew = null;
        try {
            Class<?> cls = Class.forName(SMARTS_CLASS);
            Method method = cls.getMethod("migrate", String.class, String.class, String.class);
            smartsObjectsNew = (List)method.invoke(null, moduleStoreID, moduleDefinitation, analytics);
        }
        catch (InvocationTargetException exception) {
            if (exception.getCause() != null) {
                throw new Exception(exception.getCause());
            }
            throw exception;
        }
        catch (Exception exception) {
            throw exception;
        }
        return smartsObjectsNew;
    }
}

