/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.endor;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public class UpgradeExecutionPrompt
implements CMUpgradePlugin {
    private static final String OPTIONS = "options";
    private static final String EXECUTION_PROMPT = "executionPrompt";
    private static final String PROMPT = "prompt";
    private static final String OPTION_TYPE = "runOptionBoolean";
    private static final String NAME_TYPE = "runOptionEnum";

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        Boolean executionPrompt = this.getExecutionPrompt(data);
        if (executionPrompt == null || executionPrompt.booleanValue()) {
            return null;
        }
        XMLElement options = this.getOptions(data);
        String newValue = this.setPromptOption(options);
        if (newValue != null) {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put(OPTIONS, newValue);
            return CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
        }
        return null;
    }

    private XMLElement getOptions(CMUpgradeData data) throws CMException {
        String value = (String)data.getPropertyValue(OPTIONS);
        if (value == null) {
            return null;
        }
        return CMXMLUtils.convertXMLString2XMLElement(value).getChild(0);
    }

    private Boolean getExecutionPrompt(CMUpgradeData data) throws Exception {
        String value = CMDataUpgradeUtils.getPropertyValue(data, EXECUTION_PROMPT);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    private String setPromptOption(XMLElement options) {
        XMLElement optionValue;
        XMLElement value;
        if (options == null) {
            options = new XMLElement(OPTIONS, CMSOAPConstants.NS_BIBUS, "optionArrayProp");
        }
        if ((value = options.getOptionalChildWithName("value")) == null) {
            value = options.addChild(null, "value", CMSOAPConstants.NS_BIBUS, CMPropertyTypes.BIBUS_OPTIONARRAY.getName());
        }
        XMLElement promptOption = null;
        if (value.hasChildren()) {
            for (XMLElement item : value.children_) {
                String name = item.getOptionalChildValueWithName("name");
                if (!PROMPT.equals(name)) continue;
                promptOption = item;
                break;
            }
        }
        if (promptOption == null) {
            promptOption = value.addChild(null, "item", CMSOAPConstants.NS_BIBUS, OPTION_TYPE);
            promptOption.addChild(null, "name", CMSOAPConstants.NS_BIBUS, NAME_TYPE, PROMPT);
        }
        if ((optionValue = promptOption.getOptionalChildWithName("value")) != null) {
            return null;
        }
        optionValue = promptOption.addChild(null, "value", CMPropertyTypes.XML_BOOLEAN.getNamespace(), CMPropertyTypes.XML_BOOLEAN.getName(), Boolean.toString(false));
        return options.makeXML("", true, false, false);
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

