/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.endorr3;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.plugin.cm.upgrade.utils.PathMatcherWithCAMID;
import com.cognos.cm.plugin.cm.upgrade.utils.UpgradeUtils;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;

public class RenameObjectByPath
implements CMUpgradePlugin {
    private String pathParam;
    private PathMatcherWithCAMID matcher;
    private String newNameId;

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) {
        this.pathParam = (String)desc.getParameters().get("path");
        this.newNameId = desc.getParameter("newNameId");
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (this.matcher == null) {
            this.initPath();
        }
        if (data == null) {
            return null;
        }
        try {
            String nameXML = (String)data.getPropertyValue("name");
            String searchPath = CMDataUpgradeUtils.getPropertyValue(data, "searchPath");
            if (searchPath == null) {
                return null;
            }
            if (this.matcher.match(searchPath)) {
                nameXML = UpgradeUtils.updateName(nameXML, this.newNameId);
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("name", nameXML);
                return CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
            }
            return null;
        }
        catch (Exception e) {
            return CMUpgradeResultFactory.createErrorUpgradeResult(e.getMessage());
        }
    }

    private void initPath() throws CMException {
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(this.pathParam);
        if (rootEl == null) {
            return;
        }
        this.matcher = new PathMatcherWithCAMID(rootEl.value_);
    }

    public void terminate() throws Exception {
    }
}

