/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.endorr7;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.util.CMDataUpgradeUtils;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class UpgradeDataSetFormat
implements CMUpgradePlugin {
    private static final String VALID_CONTENT_TYPE = "application/vnd.ibm.bi.pq";
    private static final String FORMAT = "format";
    private static final String DATA_TYPE = "dataType";
    private static final String UPGRADED_FORMAT = "<format><value>dataSet</value></format>";
    private static final String UPGRADED_DATA_TYPE = "<dataType><value>application/vnd.ibm.bi.pq</value></dataType>";

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (!UpgradeDataSetFormat.isDataSet(data)) {
            return null;
        }
        CMUpgradeResult result = null;
        if (CMDataUpgradeUtils.getIsFromDeployment(data) && UpgradeDataSetFormat.formatNeedsUpgrade(data)) {
            result = UpgradeDataSetFormat.createErrorResult();
        } else {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            if (UpgradeDataSetFormat.formatNeedsUpgrade(data)) {
                upgradedData.put(FORMAT, UPGRADED_FORMAT);
            }
            if (UpgradeDataSetFormat.dataTypeNeedsUpgrade(data)) {
                upgradedData.put(DATA_TYPE, UPGRADED_DATA_TYPE);
            }
            if (!upgradedData.isEmpty()) {
                result = CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
            }
        }
        return result;
    }

    private static CMUpgradeResult createErrorResult() {
        String msg = CMError.getMessageInProductLocale("cmDataSetNotUpgraded");
        CMUpgradeResult result = new CMUpgradeResult();
        result.setMessage(msg);
        result.setUpgradeStatus(3);
        return result;
    }

    private static boolean formatNeedsUpgrade(CMUpgradeData data) throws Exception {
        String format = CMDataUpgradeUtils.getPropertyValue(data, FORMAT);
        return StringUtils.isEmpty((String)format);
    }

    private static boolean dataTypeNeedsUpgrade(CMUpgradeData data) throws Exception {
        String dataType = CMDataUpgradeUtils.getPropertyValue(data, DATA_TYPE);
        return !VALID_CONTENT_TYPE.equals(dataType);
    }

    private static boolean isDataSet(CMUpgradeData data) throws Exception {
        String descriptor = CMDataUpgradeUtils.getPropertyValue(data, "dataDescriptor");
        return descriptor != null && descriptor.contains("\"container\":\"parquet\"");
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

