/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.endorr7;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.HashMap;

public class UpgradeSecureKey
implements CMUpgradePlugin {
    private final String CREDENTIAL_XML_SECUREKEY_PREFIX = "<credential><secureKey>";
    private final String CREDENTIAL_XML_SECUREKEY_SUFFIX = "</secureKey></credential>";
    private final String DATA_VALUE_XML_PREFIX = "<data><value>";
    private final String DATA_VALUE_XML_SUFFIX = "</value></data>";

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        CMUpgradeResult result = null;
        String tagValue = CMDataUpgradeUtils.getPropertyValue(data, "data");
        if (tagValue != null) {
            try {
                if (tagValue.startsWith("<credential>")) {
                    return null;
                }
                HashMap<String, String> upgradedData = new HashMap<String, String>();
                upgradedData.put("data", this.createPropertyXml(this.upgradeSecureKeyValue(tagValue)));
                result = CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
            }
            catch (Exception ex) {
                result = CMUpgradeResultFactory.createErrorUpgradeResult(ex.getMessage());
            }
        }
        return result;
    }

    private String upgradeSecureKeyValue(String tagValue) throws Exception {
        String wrappedValue = "<credential><secureKey>" + XMLUtils.escape((String)tagValue, (boolean)false) + "</secureKey></credential>";
        return Base64.encode(wrappedValue.getBytes("utf-8"));
    }

    private String createPropertyXml(String value) {
        return "<data><value>" + value + "</value></data>";
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

