/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.heliosr5;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

public class BaseModuleUpgrade
implements CMUpgradePlugin {
    private static final String DEFAULT_DATASOURCESCHEMA_SPEC = "{\"dataStatistics\":\"all\",\"excludedTables\":[],\"version\":\"1.0\",\"importPrimaryForeignKeys\":true,\"dataSamplingSize\":1000}";
    private static final String DEFAULT_DATASOURCESCHEMA_SCHEMATYPE = "user";

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String upgradeFrom = (String)data.getPropertyValue("UPGRADE_FROM");
        if (upgradeFrom.equalsIgnoreCase("DEPLOYMENT")) {
            return null;
        }
        String baseModuleOriginalSearchPath = this.getPropertyValue(data, "searchPath");
        String dataSourceConnectionSearchPath = baseModuleOriginalSearchPath + "/parent::dataSourceConnection";
        CMUpgradeResult result = new CMUpgradeResult();
        String errorMessage = null;
        try {
            String baseModuleNewSearchPath = this.renameBaseModule(baseModuleOriginalSearchPath, dataSourceConnectionSearchPath);
            dataSourceConnectionSearchPath = baseModuleNewSearchPath + "/parent::dataSourceConnection";
            String dataSourceSchemaSearchPath = this.addDataSourceSchema(dataSourceConnectionSearchPath, data);
            this.moveBaseModule(baseModuleNewSearchPath, dataSourceSchemaSearchPath);
        }
        catch (Exception ex) {
            errorMessage = ex.getMessage();
        }
        if (errorMessage != null) {
            result.setUpgradeStatus(2);
            ArrayList<CMUpgradeMessage> messages = new ArrayList<CMUpgradeMessage>();
            messages.add(new CMUpgradeMessage(errorMessage, 40000));
            result.setMessages(messages);
        } else {
            result.setUpgradeStatus(1);
        }
        result.setNextAction(1);
        return result;
    }

    private String renameBaseModule(String searchPath, String targetSearchPath) throws Exception {
        String newName = CMDateUtils.getIsoDate();
        String renameRequest = CMDataUpgradeUtils.buildMoveRename(searchPath, targetSearchPath, "baseModule", newName);
        String response = ContentManager.getInstance().ExecuteStaticRequest(renameRequest, false, true);
        if (response == null || response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Rename baseModule failed:\n" + (response != null ? response : ""));
        }
        return this.getSearchPathFromResponse(response, "./item/searchPath/value");
    }

    private String addDataSourceSchema(String searchPath, CMUpgradeData data) throws Exception {
        String addRequest = CMDataUpgradeUtils.buildAdd(searchPath, "dataSourceSchema", this.getDataSourceSchemaProperties(data));
        String response = ContentManager.getInstance().ExecuteStaticRequest(addRequest, false, true);
        if (response == null || response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Add dataSourceSchema failed:\n" + (response != null ? response : ""));
        }
        return this.getSearchPathFromResponse(response, "./item/addResult/item/searchPath/value");
    }

    private void moveBaseModule(String sourceSearchPath, String targetSearchPath) throws Exception {
        String moveRequest = CMDataUpgradeUtils.buildMove(sourceSearchPath, targetSearchPath);
        String response = ContentManager.getInstance().ExecuteStaticRequest(moveRequest, false, true);
        if (response == null || response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Move baseModule failed:\n" + (response != null ? response : ""));
        }
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }

    private List<String> getDataSourceSchemaProperties(CMUpgradeData data) throws Exception {
        ArrayList<String> props = new ArrayList<String>();
        String catalog = this.getPropertyValue(data, "catalog");
        String schema = this.getPropertyValue(data, "schema");
        String status = this.convertBaseModuleStatus(this.getPropertyValue(data, "status"));
        String defaultName = this.getPropertyValue(data, "defaultName");
        StringBuilder strBuf = new StringBuilder();
        strBuf.append("    <defaultName xsi:type=\"bus:stringProp\">\n").append("            <value xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)defaultName)).append("</value>\n").append("          </defaultName>\n").append("          <catalog xsi:type=\"bus:stringProp\">\n").append("            <value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(catalog).append("</value>\n").append("          </catalog>\n").append("          <schema xsi:type=\"bus:stringProp\">\n").append("            <value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(schema).append("</value>\n").append("          </schema>\n").append("          <status xsi:type=\"bus:stringProp\">\n").append("            <value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(status).append("</value>\n").append("          </status>\n").append("          <schemaType xsi:type=\"bus:stringProp\">\n").append("            <value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(DEFAULT_DATASOURCESCHEMA_SCHEMATYPE).append("</value>\n").append("          </schemaType>\n").append("          <specification xsi:type=\"cm:anyTypeProp\">\n").append("            <value xsi:type=\"xsd:string\" xml:space=\"preserve\">").append(DEFAULT_DATASOURCESCHEMA_SPEC).append("</value>\n").append("          </specification>\n");
        props.add(strBuf.toString());
        return props;
    }

    private String getSearchPathFromResponse(String response, String xPath) throws Exception {
        Element resultElement = CMDataUpgradeUtils.parseResponse(response);
        Node searchPathNode = resultElement.selectSingleNode(xPath);
        return searchPathNode.getText();
    }

    private String convertBaseModuleStatus(String oldStatus) {
        if (oldStatus == null) {
            return null;
        }
        String newStatus = "";
        if (oldStatus.equalsIgnoreCase("succeeded")) {
            newStatus = "loaded";
        } else if (oldStatus.equalsIgnoreCase("executing")) {
            newStatus = "loading";
        } else if (oldStatus.equalsIgnoreCase("failed")) {
            newStatus = "error";
        }
        return newStatus;
    }
}

