/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.heliosr5;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import org.dom4j.Element;

public class ModuleDeploymentReferencesUpgrade
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        XMLElement elDeployRefs = null;
        boolean upgradeRequired = false;
        try {
            String deploymentRefsXMLString = (String)data.getPropertyValue("deploymentReferences");
            String upgradeFrom = (String)data.getPropertyValue("UPGRADE_FROM");
            if (deploymentRefsXMLString == null || deploymentRefsXMLString.length() == 0) {
                return null;
            }
            XMLElement deployRefsXML = CMXMLUtils.convertXMLString2XMLElement(deploymentRefsXMLString);
            if (deployRefsXML == null) {
                return null;
            }
            elDeployRefs = deployRefsXML.getChild(0);
            upgradeRequired = this.updateDeploymentReferences(elDeployRefs, upgradeFrom);
        }
        catch (CMException e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else if (upgradeRequired) {
            String newDeployRefsXMLString = elDeployRefs.makeXML(null, true, false, false);
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            upgradedData.put("deploymentReferences", newDeployRefsXMLString);
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    private boolean updateDeploymentReferences(XMLElement elDeployRefs, String upgradeFrom) throws Exception {
        boolean upgradeRequired = false;
        XMLElement elDeployRefsArray = elDeployRefs.getChildWithName("value");
        if (elDeployRefsArray != null && elDeployRefsArray.children_ != null) {
            for (XMLElement ref : elDeployRefsArray.children_) {
                XMLElement elObjs;
                if (ref == null || ref.children_ == null || (elObjs = ref.getOptionalChildWithName("objects")) == null || elObjs.children_ == null) continue;
                for (XMLElement refObj : elObjs.children_) {
                    String refSearchPath;
                    if (refObj == null) continue;
                    String storeID = refObj.getOptionalValueFromChildWithNameWithinChildWithName("storeID", "value");
                    String sp = refObj.getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value");
                    if (upgradeFrom.equalsIgnoreCase("DEPLOYMENT")) {
                        int index = sp.indexOf("/baseModule[@name=");
                        if (index == -1) continue;
                        refSearchPath = new StringBuilder(sp).replace(index, index + 18, "/dataSourceSchema[@name=").toString();
                    } else {
                        refSearchPath = "storeID(\"" + storeID + "\")/parent::dataSourceSchema";
                    }
                    String query2 = CMDataUpgradeUtils.buildQuery(refSearchPath, new String[]{"searchPath", "storeID"});
                    String response = ContentManager.getInstance().ExecuteStaticRequest(query2, false, true);
                    CMDataUpgradeUtils.validateResponse(response);
                    Element queryResult = CMDataUpgradeUtils.parseResponse(response);
                    if (queryResult.selectSingleNode("./item") == null) continue;
                    String dssSearchPath = queryResult.selectSingleNode("./item/searchPath/value").getText();
                    XMLElement searchPathEl = refObj.getOptionalChildWithName("searchPath");
                    searchPathEl.setChildValueWithName("value", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_STRING.getName(), dssSearchPath);
                    String dssStoreID = queryResult.selectSingleNode("./item/storeID/value").getText();
                    XMLElement storeIDEl = refObj.getOptionalChildWithName("storeID");
                    storeIDEl.setChildValueWithName("value", CMSOAPConstants.NS_XMLSCHEMA, CMPropertyTypes.XML_STRING.getName(), dssStoreID);
                    upgradeRequired = true;
                }
            }
        }
        return upgradeRequired;
    }
}

