/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.heliosr9;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.constants.CMError;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class AddSysAdminMember
implements CMUpgradePlugin {
    private static String PROP_MEMBERS = "members";
    private static final String msgId = "cmInitAnalyticsAdministrators";
    ArrayList<String> roleNames = new ArrayList();

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        XMLElement membersArray;
        this.loadRoleNames();
        String membersXML = (String)data.getPropertyValue(PROP_MEMBERS);
        if (membersXML != null && this.foundRole(membersXML)) {
            return CMUpgradeResultFactory.createUpgradeNotRequiredResult();
        }
        XMLElement memberRootXML = CMXMLUtils.convertXMLString2XMLElement(membersXML);
        XMLElement elMembers = memberRootXML.getChild(0);
        if (elMembers == null) {
            elMembers = new XMLElement(PROP_MEMBERS, CMSOAPConstants.NS_BIBUS, "baseClassArrayProp");
        }
        if ((membersArray = elMembers.getOptionalChildWithName("value")) == null) {
            membersArray = elMembers.addChild(null, "value", CMSOAPConstants.NS_SOAP_ENC, "Array");
        }
        this.addMember(membersArray);
        String newMembers = elMembers.makeXML(null, true, false, false);
        HashMap<String, String> upgradedData = new HashMap<String, String>();
        upgradedData.put(PROP_MEMBERS, newMembers);
        return CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
    }

    private void loadRoleNames() throws CMException {
        CMLocalizedStringArray mls = CMLocaleUtils.getLocalizedStringsForMessageID(msgId);
        for (int i = 0; i < mls.getSize(); ++i) {
            this.roleNames.add(mls.get(i).getValue());
        }
    }

    private String getInitRoleSearchPath(String roleInitMsgId) {
        return "CAMID(\":" + CMError.getRLMessage(roleInitMsgId, Locale.ENGLISH) + "\")";
    }

    private void addMember(XMLElement membersArray) {
        String searchPath = this.getInitRoleSearchPath(msgId);
        XMLElement newMember = membersArray.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "role", null);
        XMLElement elem = newMember.addChild(null, "searchPath", CMSOAPConstants.NS_BIBUS, "stringProp", null);
        elem.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "string", searchPath);
    }

    private boolean foundRole(String membersXML) {
        for (int i = 0; i < this.roleNames.size(); ++i) {
            String localizedName = this.roleNames.get(i);
            if (membersXML.indexOf(localizedName) == -1) continue;
            return true;
        }
        return false;
    }
}

