/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.heliosr9;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.cm.upgrade.common.UpdateCapabilityPolicies;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class UpdateCapabilityPoliciesForLicenseRoles
extends UpdateCapabilityPolicies {
    private static final String ATTR_ACCESS = "access";
    HashMap<String, List<UpdateCapabilityPolicies.CapabilityData>> capabilityDataMap_ = new HashMap();

    @Override
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
        String param = (String)desc.getParameters().get("capabilities");
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(param);
        if (rootEl == null) {
            return;
        }
        XMLElement paramEl = rootEl.getChild(0);
        if (paramEl == null) {
            return;
        }
        List<UpdateCapabilityPolicies.CapabilityData> capDataList = null;
        for (XMLElement itemEl : paramEl.children_) {
            String userCapabilityEnum = itemEl.getAttribute("capEnum");
            if (userCapabilityEnum == null) {
                throw this.missingAttributeException("capEnum");
            }
            String roleInitMsgId = itemEl.getAttribute("roleInitMsg");
            if (roleInitMsgId == null) {
                throw this.missingAttributeException("roleInitMsg");
            }
            String actions = itemEl.getAttribute("actions");
            if (actions == null) {
                throw this.missingAttributeException("actions");
            }
            String access = itemEl.getAttribute(ATTR_ACCESS);
            if (access == null || access.isEmpty()) {
                access = "grant";
            }
            if ((capDataList = this.capabilityDataMap_.get(userCapabilityEnum)) == null) {
                capDataList = new ArrayList<UpdateCapabilityPolicies.CapabilityData>();
                this.capabilityDataMap_.put(userCapabilityEnum, capDataList);
            }
            capDataList.add((UpdateCapabilityPolicies)this.new UpdateCapabilityPolicies.CapabilityData(roleInitMsgId, actions, access));
        }
    }

    @Override
    protected String findCapabilityToUpgrade(String userCapabilityVal) {
        String capEnumToUpgrade = null;
        if (userCapabilityVal != null) {
            Set<String> capEnums = this.capabilityDataMap_.keySet();
            for (String cap : capEnums) {
                if (!userCapabilityVal.equals(cap)) continue;
                capEnumToUpgrade = cap;
                break;
            }
        }
        return capEnumToUpgrade;
    }

    @Override
    protected String getUpdatedPolicies(String userCapEnum, String policiesXMLString) throws CMException {
        List<UpdateCapabilityPolicies.CapabilityData> capDataList = this.capabilityDataMap_.get(userCapEnum);
        for (UpdateCapabilityPolicies.CapabilityData capData : capDataList) {
            String roleCAMID = capData.getNewRoleSearchPath();
            if (policiesXMLString.indexOf(roleCAMID) == -1) continue;
            return null;
        }
        String newPoliciesXMLString = this.addItemsToPolicies(policiesXMLString, capDataList);
        return newPoliciesXMLString;
    }

    private String addItemsToPolicies(String policiesXMLString, List<UpdateCapabilityPolicies.CapabilityData> capDataList) throws CMException {
        XMLElement elPolicies = null;
        XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
        if (policiesRootXML == null) {
            return null;
        }
        elPolicies = policiesRootXML.getChild(0);
        if (elPolicies == null) {
            return null;
        }
        XMLElement elPolicyArray = elPolicies.getChildWithName("value");
        if (elPolicyArray == null || elPolicyArray.children_ == null) {
            return null;
        }
        for (UpdateCapabilityPolicies.CapabilityData capData : capDataList) {
            String searchPath = capData.getNewRoleSearchPath();
            CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, searchPath, capData.getActions(), capData.getAccess());
        }
        return elPolicies.makeXML(null, true, false, false);
    }
}

