/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.utils;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cm.upgrade.utils.CMUpgradeResultFactory;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractAddPoliciesToCapabilitiesPlugin
implements CMUpgradePlugin {
    protected Map<String, Map<String, String[]>> capabilities = new HashMap<String, Map<String, String[]>>();

    public static String toCAMID(String role) {
        return "CAMID(\":" + role + "\")";
    }

    public void addCapability(String capability, Map<String, String[]> rolesToActions) {
        this.capabilities.put(capability, rolesToActions);
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        String policiesXMLString;
        String userCapabilityXMLString = (String)data.getPropertyValue("userCapability");
        if (this.areParametersEmpty(userCapabilityXMLString, policiesXMLString = (String)data.getPropertyValue("policies"))) {
            return null;
        }
        String capability = this.whichCapability(userCapabilityXMLString);
        if (capability == null) {
            return null;
        }
        CMUpgradeResult result = null;
        try {
            XMLElement policiesXML;
            if (!this.arePoliciesAcquired(data) && (policiesXML = this.upgradePolicies(policiesXMLString, capability)) != null) {
                String newPoliciesXMLString = policiesXML.makeXML(null, true, false, false);
                result = this.createSuccessUpgradeResult(newPoliciesXMLString);
            }
        }
        catch (Exception e) {
            result = CMUpgradeResultFactory.createErrorUpgradeResult(e.getMessage());
        }
        return result;
    }

    protected XMLElement upgradePolicies(String policiesXMLString, String capability) throws CMException {
        XMLElement policiesRootXML = CMXMLUtils.convertXMLString2XMLElement(policiesXMLString);
        XMLElement elPolicies = null;
        if (policiesRootXML != null) {
            elPolicies = policiesRootXML.getChild(0);
            if (elPolicies != null) {
                Map<String, String[]> rolesAndActions = this.capabilities.get(capability);
                XMLElement elPolicyArray = elPolicies.getChildWithName("value");
                this.addNewPolicies(elPolicyArray, rolesAndActions);
            } else {
                return null;
            }
        }
        return elPolicies;
    }

    protected boolean arePoliciesAcquired(CMUpgradeData data) {
        String isPolicyAcquired = (String)data.getPropertyValue("POLICIES_ACQUIRED");
        if (isPolicyAcquired != null) {
            return Boolean.valueOf(isPolicyAcquired);
        }
        return false;
    }

    protected boolean areParametersEmpty(String userCapabilityXMLString, String policiesXMLString) {
        return userCapabilityXMLString == null || userCapabilityXMLString.length() == 0 || policiesXMLString == null || policiesXMLString.length() == 0;
    }

    protected void addNewPolicies(XMLElement policiesArrayEle, Map<String, String[]> rolesAndActions) {
        for (String role : rolesAndActions.keySet()) {
            String roleSearchPath = AbstractAddPoliciesToCapabilitiesPlugin.toCAMID(role);
            String[] actions = rolesAndActions.get(role);
            CMDataUpgradeUtils.addPolicyToPolicyArray(policiesArrayEle, roleSearchPath, actions);
        }
    }

    protected String whichCapability(String userCapabilityXMLString) {
        for (String capability : this.capabilities.keySet()) {
            if (userCapabilityXMLString.indexOf(capability) == -1) continue;
            return capability;
        }
        return null;
    }

    protected CMUpgradeResult createSuccessUpgradeResult(String newPoliciesXMLString) {
        HashMap<String, String> upgradedData = new HashMap<String, String>();
        upgradedData.put("policies", newPoliciesXMLString);
        return CMUpgradeResultFactory.createSuccessUpgradeResult(upgradedData);
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }
}

