/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.utils;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.util.CMLocaleUtils;
import java.util.ArrayList;
import java.util.HashSet;

public class PathMatcher {
    private CMStoreXPath template;
    private ArrayList<HashSet<String>> names;
    private String className;

    public PathMatcher() {
    }

    public PathMatcher(String path) throws CMException {
        this.pathMatcher(path);
    }

    public void pathMatcher(String path) throws CMException {
        this.template = new CMStoreXPath(path);
        this.className = ((CMStoreXPathStep)this.template.stepAt((int)(this.template.size() - 1))).classpredicate_.getName();
        HashSet<Object> nulSet = new HashSet<Object>();
        nulSet.add(null);
        int n = this.template.size();
        this.names = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            CMStoreXPathStep step = (CMStoreXPathStep)this.template.stepAt(i);
            String msgId = step.getName();
            this.names.add(msgId == null ? nulSet : this.getNames(msgId));
        }
    }

    public String getObjectClass() {
        return this.className;
    }

    protected HashSet<String> getNames(String msgId) throws CMException {
        HashSet<String> set = new HashSet<String>();
        CMLocalizedStringArray mls = CMLocaleUtils.getLocalizedStringsForMessageID(msgId);
        for (int i = 0; i < mls.getSize(); ++i) {
            set.add(mls.get(i).getValue());
        }
        return set;
    }

    public boolean matches(CMStoreXPath path) {
        if (path.size() != this.template.size()) {
            return false;
        }
        for (int i = 0; i < path.size(); ++i) {
            CMStoreXPathStep tstep = (CMStoreXPathStep)this.template.stepAt(i);
            CMStoreXPathStep pstep = (CMStoreXPathStep)path.stepAt(i);
            if (tstep.getAxis() != pstep.getAxis()) {
                return false;
            }
            if (tstep.classpredicate_ != pstep.classpredicate_) {
                return false;
            }
            int n = tstep.numPredicates();
            if (n != pstep.numPredicates()) {
                return false;
            }
            if (i == 1) {
                CMConstants.FunctionDef func = tstep.getNodeSetFunction();
                if (pstep.getNodeSetFunction() != func) {
                    return false;
                }
                if (func != null) continue;
            }
            String name = pstep.getName();
            if (this.names.get(i).contains(name)) continue;
            return false;
        }
        return true;
    }
}

