/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.utils;

import com.cognos.cm.plugin.cm.upgrade.utils.PathMatcher;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class PathMatcherWithCAMID
extends PathMatcher {
    private ArrayList<HashSet<String>> names;
    private PathMatcher matcher;

    public PathMatcherWithCAMID(String path) throws CMException {
        CMStoreXPath xPath = new CMStoreXPath(path);
        String camID = this.extractCAMIDValue(xPath);
        if (camID == null) {
            this.matcher = new PathMatcher(path);
        } else {
            this.names = new ArrayList();
            this.names.add(this.getNames(camID));
        }
    }

    private String extractCAMIDValue(CMStoreXPath xPath) {
        String msgID = xPath.getCAMIDFromFirstStep();
        return StringUtils.stripStart((String)msgID, (String)":");
    }

    public boolean match(String searchPath) throws CMException {
        CMStoreXPath path = new CMStoreXPath(searchPath);
        String name = null;
        if (this.matcher != null) {
            return this.matcher.matches(path);
        }
        String camID = path.getCAMIDFromFirstStep();
        if (camID != null) {
            if (camID.equals(":") && path.size() == 2) {
                name = this.getNameAtStep1(path);
            } else if (camID.charAt(0) == ':' && path.size() == 1) {
                name = this.extractCAMIDValue(path);
            }
        }
        if (name != null) {
            for (int i = 0; i < this.names.size(); ++i) {
                if (!this.names.get(i).contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    private String getNameAtStep1(CMStoreXPath path) {
        CMStoreXPathStep step = (CMStoreXPathStep)path.stepAt(1);
        return step.getName();
    }
}

