/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cm.upgrade.utils;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMXMLUtils;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class UpgradeUtils {
    public static Document parseXMLValue(String value) throws DocumentException {
        StringBuffer buf = new StringBuffer();
        buf.append("<root ").append(XMLElement.getCMPrefixes()).append(">").append(value).append("</root>");
        SAXReader reader = new SAXReader();
        return reader.read((Reader)new StringReader(buf.toString()));
    }

    public static String updateName(String propXML, String initMsgCode) throws CMException {
        XMLElement propertyEl;
        String updatedXML = null;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(propXML);
        if (rootEl != null && (propertyEl = rootEl.getChild(0)) != null) {
            XMLElement propValueEl = propertyEl.getOptionalChildWithName("value");
            if (propValueEl != null && propValueEl.children_ != null) {
                Iterator<XMLElement> it = propValueEl.children_.iterator();
                while (it.hasNext()) {
                    XMLElement entryEl = it.next();
                    XMLElement valueEl = entryEl.getOptionalChildWithName("value");
                    XMLElement localeEl = entryEl.getOptionalChildWithName("locale");
                    if (valueEl != null && localeEl != null && localeEl.value_ != null) {
                        Locale locale = CMLocaleUtils.parseLocale(localeEl.value_);
                        String newValue = CMError.getMessage(initMsgCode, null, locale);
                        if (newValue != null && !newValue.startsWith("MSG_NOT_FOUND")) {
                            valueEl.value_ = newValue;
                            continue;
                        }
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }
            updatedXML = propertyEl.makeXML("", true, false, false);
        }
        return updatedXML;
    }

    public static boolean isMidmarket(CMUpgradeData data) {
        String targetVersion = (String)data.getPropertyValue("$VERSION_TARGET");
        return "Midmarket".equals(targetVersion);
    }
}

