/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cps.upgrade.PortalMessages;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMDataUpgradeUtils;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public abstract class BaseUpgradePortletNames
implements CMUpgradePlugin {
    private static final Namespace XSI_NAMESPACE = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private static PortalMessages MESSAGES = new PortalMessages();
    protected Map<String, String> upgradeHandles;
    private UpgradeDocument resourcesSingleton = null;
    private final Map<String, String> portletNamesMapping = new LinkedHashMap<String, String>();
    private final Map<String, String> producerNamesMapping = new LinkedHashMap<String, String>();
    private boolean isNewPortletSearchPathLoaded = false;
    private boolean isNewProducerSearchPathLoaded = false;
    private Set<String> upgradePortalPackageNames;

    public static void setPortalMessages(PortalMessages messages) {
        MESSAGES = messages;
    }

    public void initialize(CMPluginDescriptor arg0, ICCLConfiguration arg1) throws Exception {
        this.upgradeHandles = this.getUpgradeSpec();
        this.resourcesSingleton = this.getUpgradeResources();
        this.upgradePortalPackageNames = this.resourcesSingleton.getPortalPackageNames();
        this.addPortletSearchPathMappings("en");
        this.addProducerSearchPathMappings("en");
    }

    public void terminate() throws Exception {
    }

    protected String getObjectClass(String objectClass, String searchPath, String bindingXML, String portletXML) {
        return bindingXML != null ? "portletProducer" : (portletXML != null ? "portletInstance" : "portlet");
    }

    protected boolean pruned(String searchPath) {
        return false;
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        String upgradeFrom = (String)data.getPropertyValue("UPGRADE_FROM");
        String searchPath = this.getPropertyValue(data, "searchPath");
        String handle = this.getPropertyValue(data, "handle");
        String bindingXML = (String)data.getPropertyValue("binding");
        String portletXML = (String)data.getPropertyValue("portlet");
        String objectClass = this.getObjectClass(this.getPropertyValue(data, "objectClass"), searchPath, bindingXML, portletXML);
        if (this.pruned(searchPath)) {
            return null;
        }
        String nameXML = null;
        if ("pagelet".equals(objectClass)) {
            nameXML = (String)data.getPropertyValue("name");
        }
        if ((handle = this.lookupHandle(objectClass, handle, bindingXML, nameXML)) == null) {
            return null;
        }
        ObjectResources r = this.resourcesSingleton.getObjectResources(objectClass, handle);
        String upgrade_nameXML = null;
        String upgrade_descriptionXML = null;
        String upgrade_serviceDescriptionXML = null;
        String upgrade_handleXML = null;
        String upgrade_bindingXML = null;
        String upgrade_registrationXML = null;
        String upgrade_portletInstanceXML = null;
        boolean skipImportingObjectDuringDeployment = false;
        try {
            if (this.isUpgradeProperty(handle, "delete")) {
                if (upgradeFrom != null) {
                    if ("DB".equals(upgradeFrom)) {
                        this.delete(searchPath);
                        return null;
                    }
                    if ("DEPLOYMENT".equals(upgradeFrom)) {
                        skipImportingObjectDuringDeployment = true;
                    }
                }
            } else if ("portletInstance".equals(handle) && this.isUpgradeProperty(handle, "searchPath")) {
                upgrade_portletInstanceXML = this.updatePortletInstanceXMLproperty(portletXML);
            } else {
                if (this.isUpgradeProperty(handle, "name") && (upgrade_nameXML = (String)data.getPropertyValue("name")) != null) {
                    upgrade_nameXML = this.updateName(r, upgrade_nameXML);
                }
                if (this.isUpgradeProperty(handle, "description")) {
                    upgrade_descriptionXML = (String)data.getPropertyValue("description");
                    if (upgrade_descriptionXML != null) {
                        upgrade_descriptionXML = this.updateDescription(r, upgrade_descriptionXML);
                    } else if (r.newDescriptions.size() > 0) {
                        // empty if block
                    }
                }
                if (this.isUpgradeProperty(handle, "handle") && (upgrade_handleXML = (String)data.getPropertyValue("handle")) != null) {
                    upgrade_handleXML = this.updateHandle(upgrade_handleXML, handle);
                }
                if (this.isUpgradeProperty(handle, "serviceDescription")) {
                    upgrade_serviceDescriptionXML = (String)data.getPropertyValue("serviceDescription");
                    String newServiceDescription = this.resourcesSingleton.getProducerProperty("new", "serviceDescription", handle);
                    upgrade_serviceDescriptionXML = this.updateServiceDescription(handle, newServiceDescription, upgrade_serviceDescriptionXML);
                }
                if (this.isUpgradeProperty(handle, "binding")) {
                    upgrade_bindingXML = (String)data.getPropertyValue("binding");
                    String newBinding = this.resourcesSingleton.getProducerProperty("new", "binding", handle);
                    upgrade_bindingXML = this.updateBinding(newBinding, upgrade_bindingXML);
                }
                if (this.isUpgradeProperty(handle, "registration")) {
                    upgrade_registrationXML = (String)data.getPropertyValue("registration");
                    String newRegistration = this.resourcesSingleton.getProducerProperty("new", "registration", handle);
                    upgrade_registrationXML = this.updateRegistration(newRegistration, upgrade_registrationXML);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            errorMessage = t.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setUpgradeStatus(2);
            ArrayList<CMUpgradeMessage> messages = new ArrayList<CMUpgradeMessage>();
            messages.add(new CMUpgradeMessage(errorMessage, 40000));
            result.setMessages(messages);
        } else if (skipImportingObjectDuringDeployment) {
            result.setUpgradeStatus(3);
        } else if (upgrade_nameXML != null || upgrade_descriptionXML != null || upgrade_serviceDescriptionXML != null || upgrade_bindingXML != null || upgrade_registrationXML != null || upgrade_portletInstanceXML != null) {
            HashMap<String, String> upgradedData = new HashMap<String, String>();
            if (upgrade_nameXML != null) {
                upgradedData.put("name", upgrade_nameXML);
            }
            if (upgrade_descriptionXML != null) {
                upgradedData.put("description", upgrade_descriptionXML);
            }
            if (upgrade_serviceDescriptionXML != null) {
                upgradedData.put("serviceDescription", upgrade_serviceDescriptionXML);
            }
            if (upgrade_handleXML != null) {
                upgradedData.put("handle", upgrade_handleXML);
            }
            if (upgrade_bindingXML != null) {
                upgradedData.put("binding", upgrade_bindingXML);
            }
            if (upgrade_registrationXML != null) {
                upgradedData.put("registration", upgrade_registrationXML);
            }
            if (upgrade_portletInstanceXML != null) {
                upgradedData.put("portlet", upgrade_portletInstanceXML);
            }
            result.setData(upgradedData);
            result.setUpgradeStatus(1);
        } else {
            result.setUpgradeStatus(0);
        }
        result.setNextAction(1);
        return result;
    }

    protected abstract String getUpgradeSpecPath();

    protected abstract Map<String, String> getUpgradeSpec();

    protected UpgradeDocument getUpgradeResources() throws DocumentException {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getUpgradeSpecPath());
        SAXReader reader = new SAXReader();
        Document document = reader.read(is);
        return new UpgradeDocument(document.getRootElement());
    }

    private boolean isUpgradeProperty(String handle, String propName) {
        String v = this.upgradeHandles.get(handle);
        return v != null ? v.indexOf("|" + propName) != -1 : false;
    }

    protected String lookupHandle(String objectClass, String handle, String bindingXML, String nameXML) throws CMException {
        if (objectClass == null || "".equals(objectClass)) {
            return null;
        }
        String fixedHandle = handle;
        if ("portlet".equals(objectClass)) {
            int idx;
            if (fixedHandle != null && (idx = fixedHandle.indexOf("#")) != -1) {
                fixedHandle = fixedHandle.substring(0, idx);
            }
        } else if ("portletProducer".equals(objectClass)) {
            if (bindingXML != null) {
                if (bindingXML.indexOf("/wsrp/cps4/portlets/nav") != -1) {
                    fixedHandle = "/wsrp/cps4/portlets/nav";
                } else if (bindingXML.indexOf("/wsrp/cps4/portlets/utility") != -1) {
                    fixedHandle = "/wsrp/cps4/portlets/utility";
                } else if (bindingXML.indexOf("/wsrp/cps4/portlets/sdk") != -1) {
                    fixedHandle = "/wsrp/cps4/portlets/sdk";
                } else if (bindingXML.indexOf("/wsrp/fragments/markup/handle/dashboardportlets") != -1) {
                    fixedHandle = "/wsrp/fragments/markup/handle/dashboardportlets";
                } else if (bindingXML.indexOf("/wsrp/fragments/markup/handle/cmm") != -1) {
                    fixedHandle = "/wsrp/fragments/markup/handle/cmm";
                } else if (bindingXML.indexOf("/wsrp/cps4/portlets/cmm") != -1) {
                    fixedHandle = "/wsrp/cps4/portlets/cmm";
                }
            }
        } else if ("portletInstance".equals(objectClass)) {
            fixedHandle = "portletInstance";
        }
        return this.upgradeHandles.containsKey(fixedHandle) ? fixedHandle : null;
    }

    protected String extractName(String propXML, String locale) throws CMException {
        XMLElement propEl;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(propXML);
        if (rootEl != null && (propEl = rootEl.getChild(0)) != null) {
            XMLElement propValueEl = propEl.getOptionalChildWithName("value");
            boolean isUpdated = false;
            if (propValueEl != null && propValueEl.children_ != null) {
                for (XMLElement nameEl : propValueEl.children_) {
                    XMLElement nameValueEl = nameEl.getOptionalChildWithName("value");
                    XMLElement localeEl = nameEl.getOptionalChildWithName("locale");
                    String lang = localeEl.value_;
                    if (nameValueEl == null || nameValueEl.value_ == null || !locale.equals(lang)) continue;
                    return nameValueEl.value_;
                }
            }
        }
        return null;
    }

    private String upgradePortletInstanceSearchPath(String oldSearchPath) {
        String newSearchPath = null;
        int idx = oldSearchPath.indexOf("/portletProducer");
        if (idx != -1) {
            String portalPackage = this.extractPortalPackageName(oldSearchPath);
            if (this.upgradePortalPackageNames.size() == 0 || this.upgradePortalPackageNames.contains(portalPackage)) {
                String newPortletSearchPath;
                String portletSearchPath;
                String newProducerSearchPath;
                String prefix = oldSearchPath.substring(0, idx);
                String searchPath = oldSearchPath.substring(idx);
                String producerSearchPath = this.extractProducerSearchPath(searchPath);
                if (producerSearchPath != null && (newProducerSearchPath = this.getNewProducerSearchPath(producerSearchPath)) != null) {
                    newSearchPath = searchPath = newProducerSearchPath + searchPath.substring(producerSearchPath.length());
                }
                if ((portletSearchPath = this.extractPortletSearchPath(searchPath)) != null && (newPortletSearchPath = this.getNewPortletSearchPath(portletSearchPath)) != null) {
                    newSearchPath = searchPath = searchPath.substring(0, searchPath.indexOf(portletSearchPath)) + newPortletSearchPath;
                }
                if (newSearchPath != null) {
                    newSearchPath = prefix + newSearchPath;
                }
            }
        }
        return newSearchPath;
    }

    private String getNewPortletSearchPath(String searchPath) {
        String newSearchPath = this.portletNamesMapping.get(searchPath);
        if (newSearchPath == null && !this.isNewPortletSearchPathLoaded) {
            this.isNewPortletSearchPathLoaded = true;
            this.addPortletSearchPathMappings(null);
            newSearchPath = this.portletNamesMapping.get(searchPath);
        }
        return newSearchPath;
    }

    private String getNewProducerSearchPath(String searchPath) {
        String newSearchPath = this.producerNamesMapping.get(searchPath);
        if (newSearchPath == null && !this.isNewProducerSearchPathLoaded) {
            this.isNewProducerSearchPathLoaded = true;
            this.addProducerSearchPathMappings(null);
            newSearchPath = this.producerNamesMapping.get(searchPath);
        }
        return newSearchPath;
    }

    private void addPortletSearchPathMappings(String locale) {
        List<String> handles = this.resourcesSingleton.getPortletHandles();
        for (String handle : handles) {
            this.addSearchPathMappings(this.resourcesSingleton.getMultilingualStrings("old", "name", "portlet", handle), this.resourcesSingleton.getMultilingualStrings("new", "name", "portlet", handle), this.resourcesSingleton.getResourceId("name", "portlet", handle), locale, "/portlet[@name='", "']", this.portletNamesMapping);
        }
    }

    private void addProducerSearchPathMappings(String locale) {
        List<String> handles = this.resourcesSingleton.getProducerHandles();
        for (String handle : handles) {
            this.addSearchPathMappings(this.resourcesSingleton.getMultilingualStrings("old", "name", "portletProducer", handle), this.resourcesSingleton.getMultilingualStrings("new", "name", "portletProducer", handle), this.resourcesSingleton.getResourceId("name", "portletProducer", handle), locale, "/portletProducer[@name='", "']", this.producerNamesMapping);
        }
    }

    private void addSearchPathMappings(Map<String, String> oldNames, Map<String, String> newNames, String resourceId, String requestedLocale, String suffix, String prefix, Map<String, String> result) {
        Set<Map.Entry<String, String>> oldNameEntries = oldNames.entrySet();
        for (Map.Entry<String, String> entry : oldNameEntries) {
            String localeStr = entry.getKey();
            String oldName = entry.getValue();
            if (requestedLocale != null && !requestedLocale.equals(localeStr)) continue;
            String newName = this.getLocalizedString(newNames, localeStr, resourceId);
            if (newName != null && !result.containsKey(oldName)) {
                result.put(suffix + oldName + prefix, suffix + newName + prefix);
            }
            if (requestedLocale == null) continue;
            break;
        }
    }

    private String updateName(ObjectResources r, String nameXML) throws Exception {
        return this.updateXMLproperty(r.oldNames, r.newNames, r.nameResourceId, nameXML);
    }

    private String updateDescription(ObjectResources r, String descriptionXML) throws Exception {
        return this.updateXMLproperty(r.oldDescriptions, r.newDescriptions, r.descriptionResourceId, descriptionXML);
    }

    private String wrapXMLPropertyForUpdate(String name, String xmlValue) {
        String result = null;
        if (xmlValue != null) {
            Element wrap = DocumentHelper.createElement((String)name);
            wrap.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXMLProp");
            Element updateValue = wrap.addElement("value");
            updateValue.addAttribute(new QName("type", XSI_NAMESPACE), "cm:xmlEncodedXML");
            updateValue.addText(xmlValue);
            result = wrap.asXML();
        }
        return result;
    }

    protected String updateServiceDescription(String producerHandle, String newServiceDescription, String oldServiceDescription) throws Exception {
        if (newServiceDescription != null && !newServiceDescription.equals(oldServiceDescription)) {
            return this.wrapXMLPropertyForUpdate("serviceDescription", newServiceDescription);
        }
        return null;
    }

    private String updateBinding(String newBinding, String oldBinding) {
        if (newBinding != null && !newBinding.equals(oldBinding)) {
            return this.wrapXMLPropertyForUpdate("binding", newBinding);
        }
        return null;
    }

    private String updateRegistration(String newRegistration, String oldRegistration) {
        if (newRegistration != null && !newRegistration.equals(oldRegistration)) {
            return this.wrapXMLPropertyForUpdate("registration", newRegistration);
        }
        return null;
    }

    private String updateHandle(String handleXML, String newHandle) throws CMException {
        XMLElement valueEl;
        XMLElement propEl;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(handleXML);
        if (rootEl != null && (propEl = rootEl.getChild(0)) != null && (valueEl = propEl.getChild(0)) != null) {
            valueEl.value_ = newHandle;
            return propEl.makeXML("", true, false, false);
        }
        return null;
    }

    private String updateXMLproperty(Map<String, String> oldProps, Map<String, String> newProps, String resourceId, String propXML) throws CMException {
        XMLElement propEl;
        String updatedPropXML = null;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(propXML);
        if (rootEl != null && (propEl = rootEl.getChild(0)) != null) {
            XMLElement propValueEl = propEl.getOptionalChildWithName("value");
            boolean isUpdated = false;
            if (propValueEl != null && propValueEl.children_ != null) {
                for (XMLElement nameEl : propValueEl.children_) {
                    String newName;
                    String oldName;
                    XMLElement nameValueEl = nameEl.getOptionalChildWithName("value");
                    XMLElement localeEl = nameEl.getOptionalChildWithName("locale");
                    String lang = localeEl.value_;
                    if (nameValueEl == null || nameValueEl.value_ == null || "".equals(lang) || (oldName = this.getLocalizedString(oldProps, lang)) == null || (newName = this.getLocalizedString(newProps, lang, resourceId)) == null || !nameValueEl.value_.trim().equals(oldName.trim())) continue;
                    nameValueEl.value_ = newName;
                    isUpdated = true;
                }
            }
            if (isUpdated) {
                updatedPropXML = propEl.makeXML("", true, false, false);
            }
        }
        return updatedPropXML;
    }

    private String getLocalizedString(Map<String, String> values, String lang) {
        int index;
        String value = values.get(lang);
        if (value == null && (index = lang.indexOf(45)) != -1) {
            value = values.get(lang.substring(0, index));
        }
        return value;
    }

    private String getLocalizedString(Map<String, String> values, String lang, String resourceId) {
        String value = resourceId != null ? MESSAGES.getValue(resourceId, lang) : this.getLocalizedString(values, lang);
        return value;
    }

    private String updatePortletInstanceXMLproperty(String propXML) throws CMException {
        XMLElement portletEl;
        String updatedPropXML = null;
        XMLElement rootEl = CMXMLUtils.convertXMLString2XMLElement(propXML);
        if (rootEl != null && (portletEl = rootEl.getChild(0)) != null) {
            XMLElement searchPathValueEl;
            XMLElement searchPathEl;
            XMLElement itemEl;
            XMLElement valueEl = portletEl.getOptionalChildWithName("value");
            if (valueEl != null && (itemEl = valueEl.getOptionalChildWithName("item")) != null && (searchPathEl = itemEl.getOptionalChildWithName("searchPath")) != null && (searchPathValueEl = searchPathEl.getOptionalChildWithName("value")) != null && searchPathValueEl.value_ != null) {
                String upgradedSearchPath = this.upgradePortletInstanceSearchPath(searchPathValueEl.value_);
                if (upgradedSearchPath == null) {
                    return null;
                }
                searchPathValueEl.value_ = upgradedSearchPath;
            }
            updatedPropXML = portletEl.makeXML("", true, false, false);
        }
        return updatedPropXML;
    }

    private String extractProducerSearchPath(String path) {
        return this.extractString(path, "/portletProducer[@name='", "']");
    }

    private String extractPortalPackageName(String path) {
        String remaining;
        int end;
        String startMarker = "/portalPackage[@name='";
        String endMarker = "']";
        String value = null;
        int start = path.indexOf(startMarker);
        if (start != -1 && (end = (remaining = path.substring(start + startMarker.length())).indexOf(endMarker)) != -1) {
            value = remaining.substring(0, end);
        }
        return value;
    }

    private String extractPortletSearchPath(String path) {
        return this.extractString(path, "/portlet[@name='", "']");
    }

    private String extractString(String path, String startMarker, String endMarker) {
        String remaining;
        int end;
        String value = null;
        int start = path.indexOf(startMarker);
        if (start != -1 && (end = (remaining = path.substring(start)).indexOf(endMarker)) != -1) {
            value = remaining.substring(0, end + endMarker.length());
        }
        return value;
    }

    private void delete(String searchPath) throws Exception {
        String deleteRequest = CMDataUpgradeUtils.buildDelete(searchPath, false);
        String response = ContentManager.getInstance().ExecuteStaticRequest(deleteRequest, false, true);
        if (response == null || response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Delete failed:\n" + (response != null ? response : ""));
        }
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }

    private class UpgradeDocument {
        private final Element docRoot;

        public UpgradeDocument(Element docRoot) {
            this.docRoot = docRoot;
        }

        public String getResourceId(String resourcePropertyName, String objectClass, String handle) {
            if (handle != null) {
                Node node;
                StringBuffer xpath = new StringBuffer();
                if ("portlet".equals(objectClass)) {
                    xpath.append("/root/cm-resourceList/new").append("/*[local-name()='item'][@xsi:type='cm:portlet'][./*[local-name()='handle']").append("[./*[local-name()='value' and .='").append(handle).append("']]]").append("/*[local-name()='").append(resourcePropertyName).append("']/@resourceId");
                } else if ("portletProducer".equals(objectClass)) {
                    xpath.append("/root/cm-resourceList/new").append("/*[local-name()='item'][@xsi:type='cm:portletProducer']").append("[./handle='").append(handle).append("']").append("/*[local-name()='").append(resourcePropertyName).append("']/@resourceId");
                }
                if (xpath.length() > 0 && (node = this.docRoot.selectSingleNode(xpath.toString())) != null) {
                    return node.getStringValue();
                }
            }
            return null;
        }

        public Map<String, String> getMultilingualStrings(String version, String resourcePropertyName, String objectClass, String handle) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            List<Element> resourceItems = this.getMultilingualStringsElements(version, resourcePropertyName, objectClass, handle);
            if (resourceItems != null) {
                for (int i = 0; i < resourceItems.size(); ++i) {
                    Element item = resourceItems.get(i);
                    Element locale = (Element)item.selectSingleNode("locale");
                    Element name = (Element)item.selectSingleNode("value");
                    String localeStr = locale.getText();
                    String nameStr = name.getText();
                    map.put(localeStr, nameStr);
                }
            }
            return map;
        }

        public ObjectResources getObjectResources(String objectClass, String handle) {
            return new ObjectResources(this, objectClass, handle);
        }

        public String getProducerProperty(String version, String propertyName, String handle) {
            if (handle != null) {
                StringBuffer xpath = new StringBuffer();
                xpath.append("/root/cm-resourceList/").append(version).append("/*[local-name()='item'][@xsi:type='cm:portletProducer']").append("[./handle='").append(handle).append("']").append("/*[local-name()='").append(propertyName).append("']").append("/*[local-name()='value']");
                Element propertyEle = (Element)this.docRoot.selectSingleNode(xpath.toString());
                if (propertyEle != null) {
                    return propertyEle.getText();
                }
            }
            return null;
        }

        public List<String> getPortletHandles() {
            ArrayList<String> list = new ArrayList<String>();
            List portlets = this.docRoot.selectNodes("/root/cm-resourceList/old/*[local-name()='item'][@xsi:type='cm:portlet']");
            for (int i = 0; i < portlets.size(); ++i) {
                Element portlet = (Element)portlets.get(i);
                String handle = portlet.valueOf("./handle/value");
                if (handle == null) continue;
                list.add(handle);
            }
            return list;
        }

        public List<String> getProducerHandles() {
            ArrayList<String> list = new ArrayList<String>();
            List portlets = this.docRoot.selectNodes("/root/cm-resourceList/old/*[local-name()='item'][@xsi:type='cm:portletProducer']");
            for (int i = 0; i < portlets.size(); ++i) {
                Element portlet = (Element)portlets.get(i);
                String handle = portlet.valueOf("./handle");
                if (handle == null) continue;
                list.add(handle);
            }
            return list;
        }

        private List<Element> getMultilingualStringsElements(String version, String resourcePropertyName, String objectClass, String handle) {
            if (handle != null) {
                StringBuffer xpath = new StringBuffer();
                if ("portlet".equals(objectClass)) {
                    xpath.append("/root/cm-resourceList/").append(version).append("/*[local-name()='item'][@xsi:type='cm:portlet'][./*[local-name()='handle']").append("[./*[local-name()='value' and .='").append(handle).append("']]]").append("/*[local-name()='").append(resourcePropertyName).append("']").append("/*[local-name()='value']/*[local-name()='item']");
                } else if ("portletProducer".equals(objectClass)) {
                    xpath.append("/root/cm-resourceList/").append(version).append("/*[local-name()='item'][@xsi:type='cm:portletProducer']").append("[./handle='").append(handle).append("']").append("/*[local-name()='").append(resourcePropertyName).append("']").append("/*[local-name()='value']/*[local-name()='item']");
                } else if ("pagelet".equals(objectClass)) {
                    xpath.append("/root/cm-resourceList/").append(version).append("/*[local-name()='item'][@xsi:type='cm:pagelet']").append("[./handle='").append(handle).append("']").append("/*[local-name()='").append(resourcePropertyName).append("']").append("/*[local-name()='value']/*[local-name()='item']");
                }
                if (xpath.length() > 0) {
                    return XMLUtils.selectNodes((Element)this.docRoot, (String)xpath.toString());
                }
            }
            return null;
        }

        public Set<String> getPortalPackageNames() {
            HashSet<String> set = new HashSet<String>();
            List portalPacakgeNames = XMLUtils.selectNodes((Element)this.docRoot, (String)"/root/portalPackage/name/value/item/value");
            for (int i = 0; i < portalPacakgeNames.size(); ++i) {
                Element nameValue = (Element)portalPacakgeNames.get(i);
                set.add(nameValue.getText());
            }
            return set;
        }
    }

    private class ObjectResources {
        public Map<String, String> oldNames;
        public Map<String, String> newNames;
        public Map<String, String> oldDescriptions;
        public Map<String, String> newDescriptions;
        public String nameResourceId;
        public String descriptionResourceId;

        public ObjectResources(UpgradeDocument resources, String objectClass, String handle) {
            this.oldNames = resources.getMultilingualStrings("old", "name", objectClass, handle);
            this.oldDescriptions = resources.getMultilingualStrings("old", "description", objectClass, handle);
            this.newNames = resources.getMultilingualStrings("new", "name", objectClass, handle);
            this.newDescriptions = resources.getMultilingualStrings("new", "description", objectClass, handle);
            this.nameResourceId = resources.getResourceId("name", objectClass, handle);
            this.descriptionResourceId = resources.getResourceId("description", objectClass, handle);
        }
    }
}

