/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.baltic;

import com.cognos.cm.plugin.cps.upgrade.baltic.helper.Pagelet;
import com.cognos.cm.plugin.cps.upgrade.baltic.helper.PortletInstance;
import com.cognos.cm.plugin.cps.upgrade.baltic.helper.XMLDecodeReader;
import com.cognos.cm.plugin.cps.upgrade.baltic.sax.MyPageHandler;
import com.cognos.cm.util.CMXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class UpgradePortalPage {
    private String portalPage;
    private String accountPath;
    private String errorMessage;
    private static final Namespace nsCM = DocumentHelper.createNamespace((String)"cm", (String)"http://developer.cognos.com/schemas/bibus/3/");
    private static final Namespace nsXSD = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
    private static final Namespace nsSOAPENC = DocumentHelper.createNamespace((String)"SOAP-ENC", (String)"http://schemas.xmlsoap.org/soap/encoding/");
    private static final Namespace nsXSI = DocumentHelper.createNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
    private Collection<String> commands = new ArrayList<String>();

    public UpgradePortalPage(String portalPage, String accountPath) {
        this.portalPage = portalPage;
        this.accountPath = accountPath;
    }

    public void execute() {
        this.upgradePortalPage();
    }

    public Collection<String> getCommands() {
        return this.commands;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void upgradePortalPage() {
        if (this.portalPage != null && this.portalPage.length() != 0) {
            Element folderAddOp = this.createFolderAddOp();
            Collection<Pagelet> pagelets = this.parseMyPage(this.portalPage);
            Element pageletAddOp = this.createPageletsAddOp(pagelets);
            Element updateOp = this.createPortalPagesUpdateOp(pagelets);
            this.commands.add(folderAddOp.asXML());
            this.commands.add(pageletAddOp.asXML());
            this.commands.add(updateOp.asXML());
        } else {
            Element updateOp = this.createPortalPagesUpdateOp(new ArrayList<Pagelet>());
            this.commands.add(updateOp.asXML());
        }
    }

    private Element createPageletsAddOp(Collection<Pagelet> pagelets) {
        ArrayList<Element> items = new ArrayList<Element>();
        for (Pagelet pagelet : pagelets) {
            items.add(this.createPageletElement(pagelet));
            for (PortletInstance portletInstance : pagelet.portletInstances()) {
                items.add(this.createPortletInstanceElement(pagelet, portletInstance));
            }
        }
        return this.createAddOperation(items, "update");
    }

    private Element createPortletInstanceElement(Pagelet pagelet, PortletInstance portletInstance) {
        Element deploymentReferences;
        Element portletInstanceElement = DocumentHelper.createElement((String)"item");
        portletInstanceElement.addAttribute(new QName("type", nsXSI), "cm:portletInstance");
        this.addStringProp(portletInstanceElement, "defaultName", portletInstance.name());
        this.addStringProp(portletInstanceElement, "searchPath", this.accountPath + "/folder[@name='My Folders']/folder[@name='My Pagelets']/pagelet[@name='" + pagelet.name() + "']");
        Element context = DocumentHelper.createElement((String)"context");
        context.addAttribute(new QName("type", nsXSI), "cm:xmlEncodedXMLProp");
        portletInstanceElement.add(context);
        if (portletInstance.getContext().length() != 0) {
            Element contextValue = DocumentHelper.createElement((String)"value");
            contextValue.addAttribute(new QName("type", nsXSI), "cm:xmlEncodedXML");
            contextValue.setText(portletInstance.getContext());
            context.add(contextValue);
        }
        if ((deploymentReferences = this.createDeploymentReferenceElement(portletInstance)) != null) {
            portletInstanceElement.add(deploymentReferences);
        }
        Element portlet = DocumentHelper.createElement((String)"portlet");
        portlet.addAttribute(new QName("type", nsXSI), "cm:baseClassArrayProp");
        portletInstanceElement.add(portlet);
        Element portletValue = DocumentHelper.createElement((String)"value");
        portletValue.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
        portletValue.addAttribute(new QName("arrayType", nsSOAPENC), "cm:baseClass[]");
        portlet.add(portletValue);
        Element portletItem = DocumentHelper.createElement((String)"item");
        portletItem.addAttribute(new QName("type", nsXSI), "cm:nil");
        this.addStringProp(portletItem, "searchPath", portletInstance.getPortletPath());
        portletValue.add(portletItem);
        this.addOwner(portletInstanceElement);
        return portletInstanceElement;
    }

    private Element createDeploymentReferenceElement(PortletInstance portletInstance) {
        Element deploymentReferences = null;
        Map<String, String> deploymentReferencesMap = portletInstance.getDeploymentReferences();
        if (deploymentReferencesMap.size() > 0) {
            deploymentReferences = DocumentHelper.createElement((String)"deploymentReferences");
            deploymentReferences.add(nsCM);
            deploymentReferences.add(nsXSD);
            deploymentReferences.addAttribute(new QName("type", nsXSI), "cm:deploymentReferenceArrayProp");
            Element deploymentReferencesValue = deploymentReferences.addElement("value");
            deploymentReferencesValue.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
            deploymentReferencesValue.addAttribute(new QName("arrayType", nsSOAPENC), "cm:deploymentReference[]");
            for (Map.Entry<String, String> entry : deploymentReferencesMap.entrySet()) {
                this.addDeploymentReference(entry.getKey(), entry.getValue(), deploymentReferencesValue);
            }
        }
        return deploymentReferences;
    }

    private void addDeploymentReference(String propName, String propValue, Element deploymentReferencesValue) {
        Element item = deploymentReferencesValue.addElement("item");
        item.addAttribute(new QName("type", nsXSI), "cm:deploymentReference");
        Element name = item.addElement("name");
        name.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
        name.addAttribute(new QName("arrayType", nsSOAPENC), "cm:multilingualToken[1]");
        Element multilingualItem = name.addElement("item");
        multilingualItem.addAttribute(new QName("type", nsXSI), "cm:multilingualToken");
        Element multilingualLocale = multilingualItem.addElement("locale");
        multilingualLocale.addAttribute(new QName("type", nsXSI), "xsd:string");
        multilingualLocale.addText("en");
        Element multilingualValue = multilingualItem.addElement("value");
        multilingualValue.addAttribute(new QName("type", nsXSI), "xsd:string");
        multilingualValue.addText(propName);
        Element objects = item.addElement("objects");
        objects.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
        objects.addAttribute(new QName("arrayType", nsSOAPENC), "cm:baseClass[1]");
        Element objectsItem = objects.addElement("item");
        Element searchPath = objectsItem.addElement("searchPath");
        searchPath.addAttribute(new QName("type", nsXSI), "cm:stringProp");
        Element searchPathValue = searchPath.addElement("value");
        searchPathValue.addAttribute(new QName("type", nsXSI), "xsd:string");
        searchPathValue.addText(propValue);
    }

    private Element createPageletElement(Pagelet pagelet) {
        Element pageletElement = DocumentHelper.createElement((String)"item");
        pageletElement.addAttribute(new QName("type", nsXSI), "cm:pagelet");
        this.addStringProp(pageletElement, "defaultName", pagelet.name());
        this.addStringProp(pageletElement, "searchPath", this.accountPath + "/folder[@name='My Folders']/folder[@name='My Pagelets']");
        Element layout = DocumentHelper.createElement((String)"layout");
        layout.addAttribute(new QName("type", nsXSI), "cm:xmlEncodedXMLProp");
        pageletElement.add(layout);
        Element value = DocumentHelper.createElement((String)"value");
        value.addAttribute(new QName("type", nsXSI), "cm:xmlEncodedXML");
        value.setText(pagelet.getLayout());
        layout.add(value);
        this.addOwner(pageletElement);
        return pageletElement;
    }

    private Collection<Pagelet> parseMyPage(String portalPage) {
        try {
            XMLReader parser = CMXMLUtils.getSAXParserFromPool();
            MyPageHandler handler = new MyPageHandler(parser);
            parser.setContentHandler(handler);
            XMLDecodeReader portalPageReader = new XMLDecodeReader(new StringReader(portalPage));
            parser.parse(new InputSource(portalPageReader));
            return handler.getPagelets();
        }
        catch (SAXException e) {
            this.errorMessage = e.getMessage();
        }
        catch (IOException e) {
            this.errorMessage = e.getMessage();
        }
        return new ArrayList<Pagelet>();
    }

    private Element createPortalPagesUpdateOp(Collection<Pagelet> pagelets) {
        ArrayList<Element> items = new ArrayList<Element>();
        Element account = DocumentHelper.createElement((String)"item");
        account.addAttribute(new QName("type", nsXSI), "cm:account");
        this.addStringProp(account, "searchPath", this.accountPath);
        items.add(account);
        Element portalPages = DocumentHelper.createElement((String)"portalPages");
        portalPages.addAttribute(new QName("type", nsXSI), "cm:baseClassArrayProp");
        Element portalPagesValue = DocumentHelper.createElement((String)"value");
        portalPagesValue.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
        portalPagesValue.addAttribute(new QName("arrayType", nsSOAPENC), "cm:baseClass[]");
        portalPages.add(portalPagesValue);
        Element publicFolders = DocumentHelper.createElement((String)"item");
        publicFolders.addAttribute(new QName("type", nsXSI), "cm:nil");
        this.addStringProp(publicFolders, "searchPath", "/content");
        portalPagesValue.add(publicFolders);
        Element myFolders = DocumentHelper.createElement((String)"item");
        myFolders.addAttribute(new QName("type", nsXSI), "cm:nil");
        this.addStringProp(myFolders, "searchPath", this.accountPath + "/folder[@name='My Folders']");
        portalPagesValue.add(myFolders);
        for (Pagelet pagelet : pagelets) {
            Element item = DocumentHelper.createElement((String)"item");
            item.addAttribute(new QName("type", nsXSI), "cm:nil");
            this.addStringProp(item, "searchPath", this.accountPath + "/folder[@name='My Folders']/folder[@name='My Pagelets']/pagelet[@name='" + pagelet.name() + "']");
            portalPagesValue.add(item);
        }
        account.add(portalPages);
        Element portalPage = DocumentHelper.createElement((String)"portalPage");
        portalPage.addAttribute(new QName("type", nsXSI), "cm:anyTypeProp");
        Element portalPageValue = DocumentHelper.createElement((String)"value");
        portalPageValue.addAttribute(new QName("type", nsXSI), "xsi:string");
        portalPage.add(portalPageValue);
        account.add(portalPage);
        return this.createUpdateOperation(items, "update");
    }

    private Element createUpdateOperation(List<Element> items, String updateOption) {
        Element updateOp = DocumentHelper.createElement((QName)new QName("update", nsCM));
        updateOp.add(nsXSD);
        updateOp.add(nsSOAPENC);
        Element objects = DocumentHelper.createElement((String)"objects");
        objects.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
        objects.addAttribute(new QName("arrayType", nsSOAPENC), "cm:baseClass[]");
        updateOp.add(objects);
        if (updateOption != null) {
            Element options = DocumentHelper.createElement((String)"options");
            options.addAttribute(new QName("type", nsXSI), "cm:addOptions");
            updateOp.add(options);
            Element updateAction = DocumentHelper.createElement((String)"updateAction");
            updateAction.addAttribute(new QName("type", nsXSI), "cm:updateActionEnum");
            updateAction.setText(updateOption);
            options.add(updateAction);
        }
        Iterator<Element> it = items.iterator();
        while (it.hasNext()) {
            objects.add(it.next());
        }
        return updateOp;
    }

    private Element createFolderAddOp() {
        ArrayList<Element> items = new ArrayList<Element>();
        Element myFolders = DocumentHelper.createElement((String)"item");
        myFolders.addAttribute(new QName("type", nsXSI), "cm:folder");
        this.addStringProp(myFolders, "nameID", "cmInitMyFolders");
        this.addStringProp(myFolders, "searchPath", this.accountPath);
        items.add(myFolders);
        this.addOwner(myFolders);
        Element myPagelets = DocumentHelper.createElement((String)"item");
        myPagelets.addAttribute(new QName("type", nsXSI), "cm:folder");
        this.addStringProp(myPagelets, "nameID", "cmInitMyPagelets");
        this.addStringProp(myPagelets, "searchPath", this.accountPath + "/folder[@name='My Folders']");
        items.add(myPagelets);
        this.addOwner(myPagelets);
        return this.createAddOperation(items, "update");
    }

    private void addStringProp(Element item, String propName, String propValue) {
        Element prop = DocumentHelper.createElement((String)propName);
        prop.addAttribute(new QName("type", nsXSI), "cm:stringProp");
        item.add(prop);
        Element value = DocumentHelper.createElement((String)"value");
        value.addAttribute(new QName("type", nsXSI), "xsi:string");
        value.setText(propValue);
        prop.add(value);
    }

    private Element createAddOperation(List<Element> items, String addOption) {
        Element addOp = DocumentHelper.createElement((QName)new QName("add", nsCM));
        addOp.add(nsXSD);
        addOp.add(nsSOAPENC);
        Element objects = DocumentHelper.createElement((String)"objects");
        objects.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
        objects.addAttribute(new QName("arrayType", nsSOAPENC), "cm:baseClass[]");
        addOp.add(objects);
        if (addOption != null) {
            Element options = DocumentHelper.createElement((String)"options");
            options.addAttribute(new QName("type", nsXSI), "cm:addOptions");
            addOp.add(options);
            Element updateAction = DocumentHelper.createElement((String)"updateAction");
            updateAction.addAttribute(new QName("type", nsXSI), "m:updateActionEnum");
            updateAction.setText(addOption);
            options.add(updateAction);
        }
        Iterator<Element> it = items.iterator();
        while (it.hasNext()) {
            objects.add(it.next());
        }
        return addOp;
    }

    private void addOwner(Element element) {
        if (this.accountPath != null && !this.accountPath.startsWith("/configuration")) {
            Element owner = DocumentHelper.createElement((String)"owner");
            owner.addAttribute(new QName("type", nsXSI), "cm:baseClassArrayProp");
            Element ownerValue = DocumentHelper.createElement((String)"value");
            ownerValue.addAttribute(new QName("type", nsXSI), "SOAP-ENC:Array");
            ownerValue.addAttribute(new QName("arrayType", nsSOAPENC), "cm:baseClass[]");
            owner.add(ownerValue);
            Element item = DocumentHelper.createElement((String)"item");
            item.addAttribute(new QName("type", nsXSI), "cm:nil");
            this.addStringProp(item, "searchPath", this.accountPath);
            ownerValue.add(item);
            element.add(owner);
        }
    }
}

