/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.baltic;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradePlugin;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.cm.plugin.cps.upgrade.baltic.UpgradePortalPage;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cmutils.xml.XMLUtils;
import java.util.Collection;
import java.util.Iterator;

public class UpgradePortalPages
implements CMUpgradePlugin {
    public void initialize(CMPluginDescriptor desc, ICCLConfiguration config) throws Exception {
    }

    public void terminate() throws Exception {
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) throws Exception {
        if (data == null) {
            return null;
        }
        String errorMessage = null;
        boolean abortUpgrade = false;
        try {
            String portalPages = (String)data.getPropertyValue("portalPages");
            if (portalPages != null && portalPages.length() > 0) {
                return null;
            }
            String portalPage = this.getPropertyValue(data, "portalPage");
            String accountPath = this.getPropertyValue(data, "searchPath");
            if (accountPath == null || accountPath.length() == 0) {
                return null;
            }
            portalPage = portalPage == null ? "" : XMLUtils.escape((String)portalPage);
            UpgradePortalPage upgradePortalPage = new UpgradePortalPage(portalPage, accountPath);
            upgradePortalPage.execute();
            errorMessage = upgradePortalPage.getErrorMessage();
            if (errorMessage == null) {
                Collection<String> commands = upgradePortalPage.getCommands();
                Iterator<String> i = commands.iterator();
                while (errorMessage == null && i.hasNext()) {
                    String command = i.next();
                    String response = ContentManager.getInstance().ExecuteStaticRequest(command, false, true);
                    if (response == null) {
                        abortUpgrade = true;
                        errorMessage = "CM has been shutdown. Abort data upgrade!";
                        continue;
                    }
                    if (response.indexOf("<SOAP-ENV:Fault") == -1) continue;
                    errorMessage = response;
                }
            }
        }
        catch (Exception e) {
            errorMessage = e.getMessage();
        }
        CMUpgradeResult result = new CMUpgradeResult();
        if (errorMessage != null) {
            result.setMessage(errorMessage);
            result.setUpgradeStatus(2);
        } else {
            result.setUpgradeStatus(1);
        }
        if (abortUpgrade) {
            result.setNextAction(2);
        } else {
            result.setNextAction(1);
        }
        return result;
    }

    private String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && propXML.length() > 0 && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }
}

