/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.plugin.cps.upgrade.baltic.helper;

import com.cognos.cm.plugin.cps.upgrade.baltic.helper.base64;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class PortletInstance
implements Comparable<PortletInstance> {
    private static final Namespace nsCPS = DocumentHelper.createNamespace((String)"cps", (String)"http://developer.cognos.com/schemas/cps/asm/objects/1/");
    private static final Namespace nsWSRP = DocumentHelper.createNamespace((String)"wsrp", (String)"urn:oasis:names:tc:wsrp:v1:types");
    private static final Namespace nsCPSExt = DocumentHelper.createNamespace((String)"cpsext", (String)"http://developer.cognos.com/schemas/cps/wsrp/extensions/1/");
    private String name;
    private int columnOrder;
    private int documentOrder;
    private String portletPath;
    private List<Element> params = new ArrayList<Element>();
    private String handle;
    private Map<String, String> deploymentReferences = new HashMap<String, String>();

    public PortletInstance(String name) {
        this.name = name;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public String name() {
        return this.name;
    }

    public void setDocumentOrder(int documentOrder) {
        this.documentOrder = documentOrder;
    }

    public void setColumnOrder(String columnOrderString) {
        try {
            this.columnOrder = Integer.decode(columnOrderString);
        }
        catch (Throwable t) {
            this.columnOrder = 0;
        }
    }

    public void addParam(String name, String value) {
        this.addParam(name, value, false);
    }

    public void addParam(String name, String value, boolean web64) {
        Element param = DocumentHelper.createElement((String)"param");
        param.addAttribute("name", name);
        if (web64) {
            param.setText(PortletInstance.web64encode(value, false));
        } else {
            param.setText(value);
        }
        this.params.add(param);
    }

    public void addDeploymentReference(String name, String searchPath) {
        this.deploymentReferences.put(name, searchPath);
    }

    public Map<String, String> getDeploymentReferences() {
        return this.deploymentReferences;
    }

    public String getContext() {
        if (this.params.size() == 0) {
            return "";
        }
        Element portletContext = DocumentHelper.createElement((QName)new QName("portletContext", nsCPS));
        Element portletHandle = DocumentHelper.createElement((QName)new QName("portletHandle", nsWSRP));
        String pHandle = this.handle == null ? this.name : this.handle + ":" + this.name;
        portletHandle.setText(pHandle);
        portletContext.add(portletHandle);
        Element portletState = DocumentHelper.createElement((QName)new QName("portletState", nsWSRP));
        StringBuffer sbuf = new StringBuffer();
        for (Element element : this.params) {
            sbuf.append(element.asXML());
        }
        String encodedPortletState = PortletInstance.base64encode(sbuf.toString(), true);
        portletState.setText(encodedPortletState);
        portletContext.add(portletState);
        if (this.deploymentReferences.size() > 0) {
            Element extensions = DocumentHelper.createElement((QName)new QName("extensions", nsWSRP));
            portletContext.add(extensions);
            Element state = DocumentHelper.createElement((QName)new QName("state", nsCPSExt));
            extensions.add(state);
            for (Map.Entry<String, String> entry : this.deploymentReferences.entrySet()) {
                Element ref = DocumentHelper.createElement((QName)new QName("externalRef", nsCPSExt));
                ref.addAttribute("name", entry.getKey());
                ref.addAttribute("type", "nav");
                ref.setText(entry.getValue());
                state.add(ref);
            }
        }
        return portletContext.asXML();
    }

    public void setPortletPath(String portletPath) {
        this.portletPath = portletPath;
    }

    public String getPortletPath() {
        return this.portletPath;
    }

    @Override
    public int compareTo(PortletInstance p) {
        if (this.equals(p)) {
            return 0;
        }
        if (this.columnOrder != p.columnOrder) {
            return p.columnOrder - this.columnOrder;
        }
        return this.documentOrder - p.documentOrder;
    }

    public static String base64encode(String value, boolean compress) {
        try {
            byte[] b = value.getBytes("UTF-8");
            if (compress) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length());
                GZIPOutputStream gzos = new GZIPOutputStream(bos);
                gzos.write(b);
                gzos.close();
                b = bos.toByteArray();
            }
            return base64.encode(0, b);
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String web64encode(String value, boolean compress) {
        try {
            byte[] b = value.getBytes("UTF-8");
            if (compress) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(value.length());
                GZIPOutputStream gzos = new GZIPOutputStream(bos);
                gzos.write(b);
                gzos.close();
                b = bos.toByteArray();
            }
            return base64.encode(1, b);
        }
        catch (Exception e) {
            return value;
        }
    }
}

